////////////////////////////////////////////////////////////////////////////////////////////////////
//ANDRUINO LIBRARY
//A.Scavuzzo
//www.andruino.it
//STRUCT
//
//DON'T MODIFY THIS FILE!!!!!!!!!
//DON'T MODIFY THIS FILE!!!!!!!!!
//DON'T MODIFY THIS FILE!!!!!!!!!
//DON'T MODIFY THIS FILE!!!!!!!!!
//DON'T MODIFY THIS FILE!!!!!!!!!
////////////////////////////////////////////////////////////////////////////////////////////////////

#define cmd_lenght 15
#define port_lenght 10
#define action_lenght 25
#define action2_lenght 20
#define action3_lenght 16
#define action4_lenght 16
#define action5_lenght 16

#define MAX_CMD 4


//4 bytes
typedef struct {
  char cmd[cmd_lenght];
  char port[port_lenght];
  char action[action_lenght];
  char action2[action2_lenght];
  char action3[action3_lenght];
  char action4[action4_lenght];
  char action5[action5_lenght];
} CommandQueue;

CommandQueue CmdQueue[MAX_CMD];

//4 bytes
typedef struct {
  byte high_cnt;                  //event counter high limit
  byte low_cnt;                   //event counter low limit
  byte events_cnt;                //event counter 0:255
  byte max_events : 4;            //max event triggered 0:15?
} LimitStruct;

//3 bytes
typedef struct {
  byte cnt;
  byte events_cnt;
  byte max_events: 4;            //max event triggered 0:15?
} LimitDigStruct;


typedef struct {
  byte pin : 6;               //MAX 2^6=64 pin
  byte mode : 2;              //mode=0 -- input, mode=1 --output, mode=2 --pwm
  byte state : 8;             //max 256

  //Write request used for remote units
  byte Wstate;                //write state

  boolean W;                     //write enable //Write request used for remote units
  boolean pulse : 1;
  boolean used : 1;           //pin used?
  boolean inv : 1;            //inverted state
  boolean  alarm;						  ////used to store the alarm trigger (H or L)

  //used to understand if the limit reached is high or low
  LimitDigStruct Limit;

  //counter for output timer
  unsigned int time_counter;			//(seconds, from 0 to 65535 - 0 to 18,2 hours)

  //16bit (used 9 bits)
  unsigned int enable_limits : 9; 							//already stored in flash
  //enable action when a  limit is reached (push or output)
  //BIT10=00 ->no limit enabled
  //BIT10=01 ->push enabled
  //BIT10=10 ->output enabled
  //BIT10=01 ->push/out enabled
  //BIT72=XXXXX ->output
  //BIT8=0/1 ->polarity limit
} DigitalPin;



//18 BYTES
typedef struct {
  byte pin : 6;
  float value;          //32 bits
  uint16_t state;       //value from adc

  //used to understand if the limit reached is high or low
  LimitStruct Limit;

  bool used : 1;
  unsigned int  max;                                         //limits are *1024
  unsigned int  min;                                         //limits are *1024
  unsigned int  enable_limits : 9;                           //enable action when a  limit is reached (push or output)
  //BIT10=00 ->no limit enabled
  //BIT10=01 ->push enabled
  //BIT10=10 ->output enabled
  //BIT10=11 ->push/out enabled
  //BIT72=XXXXX ->output from 0 to 63
  //BIT8=0/1 ->polarity limit
} AnalogPin;


//14 bytes
typedef struct {
  byte pin : 6;
  float value;                  //4 bytes
  //used to understand if the limit reached is high or low
  LimitStruct Limit;            //4 BYTES

  unsigned int  max;            //2 bytes
  unsigned int  min;            //2 bytes
  unsigned int  enable_limits : 9;     //2 bytes, enable action when a  limit is reached (push or output)
  //BIT10=00 ->no limit enabled
  //BIT10=01 ->push enabled
  //BIT10=10 ->output enabled
  //BIT10=11 ->push/out enabled
  //BIT72=XXXXX ->output  from 0 to 63
  //BIT8=0/1 ->polarity limit
} Variable;



#if NRF24L_ENABLE == 1
//TYPES FOR NRF UNITS (each unit can have analog/digital pins)
typedef struct {
  DigitalPin DigPin[NRF24LMaxDigitalPin];
  AnalogPin AnaPin[NRF24LMaxAnalogPin];
  Variable VarPin[NRF24LMaxVariable];
  uint8_t dig_num;                  //number of digital pin =0
  uint8_t ana_num;                  //number of analog pin =0
  uint8_t var_num;                  //number of variable pin =0

  float AdcStep;
  uint16_t Supply;
  uint16_t RNF24LAddr;
  uint16_t samples;                  //used to know how many samples has been received
  //fix 6.11
  uint16_t sleep_time_value;          //sleep seconds for the remote Arduino
  uint16_t alive_counter;            //used to know if the sensor is alive
  uint16_t alive_fail_counter;       //used to know if the sensor has been disconnected
  bool system_back_wr;               //used to send back system data
  uint16_t fw_version;               //firmware version
  uint8_t pa_level;                  //level of PA transmitter
  uint8_t leaf;                  //level of PA transmitter =255
} SystemNRF24LPinsType;
#endif
