////////////////////////////////////////////////////////////////////////////////////////////////////
//ANDRUINO LIBRARY
//A.Scavuzzo
//www.andruino.it
//SET NETWORK
////////////////////////////////////////////////////////////////////////////////////////////////////



//enable server mode (direct connection arduino to andruino)
#define SERVER_MODE             1                               //server mode connection (1) enable default, (0) disable



//if 1, the IP is given by the router (DHCP). (Default is 1)
#define ETHERNET_DHCP           1

//#####################################
//ONLY IF ETHERNET_DHCP = 0 (above)
//192.164.0.IP_LSB
//10.0.0.IP_LSB
//#####################################
#define IP_LSB                  15


//if 1, the gateway is forced (default 0)
#define GATEWAY_DNS             0
#define GATEWAY_IP_LSB          1


//you can leave as they are
byte mac[] = {0x00, 0x17, 0xf2, 0xd1, 0x01, 0x4A};                            //MAC ADDRESS (you can modify it or leave as it is)


//dnsAdd, change it if you have problem with push and datalogging (search dns address on google according to your provider)
byte dnsAdd[] = {8, 8, 8, 8};                                                 //<<<<-----change it, DNS NUMBER (you can modify it)



//##########################
//NRF NETWORD ID
//Use same hex number on the NRF24L nodes (below is the default, you can leave as it is or change it if in the neighborhood someone uses Andruino)
//##########################
#define NRF_CHANNEL_NUM 100                                                   //NRF channel number used
byte nrf_pipeline_id[] = {0x2d, 0x4b, 0x60, 0x87, 0x96, 0xb4};                //you can leave them as default



//##########################
//ESP8266
//default password used to configure ESP by captive portal (access point used to configure email, pin and board name)
//##########################
#define ESP8266_AP_WIFI_PASS "12345678"






//DON'T MODIFY THE BELOW
//directive compilation checks
//************************************************************************************************//
#if ARDUINO_2560MEGA == 1 && (NODE_MCU == 1 || ESP8266_12E_CONF2 == 1  || WEMOS_D1_MINI == 1 || SONOFF_S20 == 1 || SONOFF_TH10 == 1 || SONOFF_BASIC == 1)
#error "Error, open A_SET_CONFIG and configure the board option correctly. With Arduino Mega is not possible to select the options used by ESP8266 as: NODE_MCU, SONOFF_S20 and SONOFF_TH10 and SONOFF_BASIC"
#elif MCU_ESP8266 == 1 && (ETHERNET_SHIELD == 1 || ETHERNET_SHIELD_V2 == 1 || WIFI_ESP8266_SHIELD == 1)
#error "Error, open A_SET_CONFIG and configure the board option correctly. With ESP8266 board is not possible to select the options used for Arduino Mega as: ETHERNET_SHIELD, ETHERNET_SHIELD_V2, WIFI_ESP8266_SHIELD"
#endif

#if ARDUINO_2560MEGA == 1 && ((ETHERNET_SHIELD +ETHERNET_SHIELD_V2+WIFI_ESP8266_SHIELD)>1 || (ETHERNET_SHIELD +ETHERNET_SHIELD_V2+WIFI_ESP8266_SHIELD) == 0)
#error "Error, open A_SET_CONFIG and configure the board option correctly. Only one option can be selected: ETHERNET_SHIELD or ETHERNET_SHIELD_V2 or WIFI_ESP8266_SHIELD"
#endif

#if MCU_ESP8266 == 1 && ((NODE_MCU + ESP8266_12E_CONF2+ WEMOS_D1_MINI+SONOFF_S20+SONOFF_TH10+SONOFF_BASIC+ESP8266_01_GENERIC) != 1)
#error "Error, open A_SET_CONFIG and configure the board option correctly. Only one option can be selected: NODE_MCU or SONOFF_S20 or SONOFF_TH10 or SONOFF_BASIC"
#endif



//************************************************************************************************//
//DEBUG on SERIAL MONITORS -> DEFINES
//ENABLE SERIAL ONLY FOR DEBUG PRINTING WARNING, DEBUG SERIAL USE TOO RAM
//************************************************************************************************//

#define DEBUG_SERIAL 1               //enable serial debug (uses pin0 and 1).
#define DEBUG_SERIAL_INTERRUPT 0     //print each second debug variables
#define DEBUG_SERIAL_CMD 1           //commands received
#define DEBUG_SERIAL_TIMER 0         //enable serial debug LEVEL 2
#define DEBUG_SERIAL_JSON 0          //enable serial debug JSON DIGITAL/ANALOG TX (uses pin0 and 1).
#define DEBUG_SERIAL_RAM 0           //enable serial debug FREE RAM (uses pin0 and 1).
#define DEBUG_SERIAL_EEPROM 0        //enable serial debug for EEPROM space address.
#define DEBUG_SERIAL_GPIO 0          //enable serial debug GPIO (uses pin0 and 1).
#define DEBUG_SERIAL_IRMS 0          //enable serial debug IRMS (uses pin0 and 1).
#define DEBUG_SERIAL_PUSH 0         //PUSH
#define DEBUG_SERIAL_SENSORS 0      //SENSORS PRINT READ
#define DEBUG_SERIAL_LIMITS 0       //LIMITS and TRIGGER EVENTS
#define DEBUG_SERIAL_NRF24L 0       //NRF module
#define DEBUG_SERIAL_CLIENT_SEND_DATA 0   //DATA client sent
#define DEBUG_SERIAL_SERVER 0       //HTTP
#define DEBUG_SERIAL_CLIENT 0       //HTTP
#define DEBUG_SERIAL_HTTP_TRASMIT 0 //HTTP stream trasmitted
#define DEBUG_SERIAL_HTTP_RECEIVE 0 //Http stream received
