
////////////////////////////////////////////////////////////////////////////////////////////////////
//ANDRUINO LIBRARY
//A.Scavuzzo
//www.andruino.it
////////////////////////////////////////////////////////////////////////////////////////////////////

/*bool  push_CheckPin();
  bool  push_SendPush(char*www_ssite, char *push_usr, char *arduino_name, char *type, char *mode, char *group, byte port, byte lim, float value, bool force);
  bool  push_SendPush2(char*www_site, char *push_usr, char *arduino_name, char *type, char *msg, bool force);
*/


bool  push_CheckPin()
{
  if (pin_push_flash < 1000 || pin_push_flash > 9999) {       //PIN not valid
#if DEBUG_SERIAL == 1
    //        Serial.println(F("push pin empty"));
#endif
    push_fail_cnt++;                                        //increment the counter of bad push connection
    return false;
  }
  return true;
}

//push_SendPush(andruino_it_ip_address, push_user, board_name_array, "lim","ana","arduino_io", ArduinoAnalog[i].pin,OutOfLimits,ArduinoAnalog[i].value)
//push_SendPush(andruino_it_ip_address, push_user, board_name_array, "lim","dig","arduino_io", ArduinoIO[i].pin,OutOfLimits,ArduinoIO[i].state)
//push_SendPush(andruino_it_ip_address, push_user, board_name_array, "lim","var","arduino_io" ,i , OutOfLimits,Arduino_User_var[i].value)
//push_SendPush(andruino_it_ip_address, push_user, board_name_array, "pow","","",0,valore, SKETCH_VERSION)
bool  push_SendPush(char *www_site, char *push_usr, char *arduino_name, char *type, char *mode, char *group, byte port, byte lim, float value, bool force)

{
  bool connected = false;
  byte retries = 0;

  if (!push_CheckPin() && force == false) {  //if PIN=0 or PIN>9999 pin is wrong or  first time connection, so skip push connection
    return 0;
  }

#if DEBUG_SERIAL == 1
  Serial.print(F("push_SendPush: ")); Serial.print(andruino_it_ip_address);
#endif
  char *result = 0;


  unsigned long int performance_start = millis();

  //retries two times if connection is not estabilished
  while (!connected && retries < MAX_RETRIES_NUM) {
    if (retries > 0) {
      ethbuff_delay_and_stop();
#if DEBUG_SERIAL_CLIENT == 1
      Serial.print(F("SendPush retries:")); Serial.print(retries);
#endif
    }
    connected = _client.connect(www_site, 80);
    retries++;
  }

  if (connected) {        ///andruino.it as number

#if DEBUG_SERIAL == 1
    Serial.println(F(" result: PASS"));
#endif


    //&type=lim (lim)
    //&mode=ana (type, ana or var or in)
    //&port=2  (port number)
    //group=arduino_io o XBee_io_0/XBee_io_1
    //&lim=1   (1 means that the high limit is reached, 2 for lower limit)
    //&value=25
    //&ardu=arduino (arduino user identify)
    //andrea_push?type=limits&mode=Ana&port=1&lim=hi&value=0.11
    ethbuff_ClientClear();                  //clear the TX buffer before use it
    ethbuff_ClientPrint(F("GET /iws4_arduino/send_push.php?user="));
    ethbuff_ClientPrint(push_usr);
    ethbuff_ClientPrint(F("&pin="));
    ethbuff_ClientPrint(pin_push_flash);
    ethbuff_ClientPrint(F("&ardu="));
    ethbuff_ClientPrint(arduino_name);
    ethbuff_ClientPrint(F("&type="));
    ethbuff_ClientPrint(type);
    ethbuff_ClientPrint(F("&mode="));
    ethbuff_ClientPrint(mode);
    ethbuff_ClientPrint(F("&port="));
    ethbuff_ClientPrint(port);
    ethbuff_ClientPrint(F("&group="));
    ethbuff_ClientPrint(group);
    ethbuff_ClientPrint(F("&lim="));
    ethbuff_ClientPrint(lim);
    ethbuff_ClientPrint(F("&value="));
    ethbuff_ClientPrint(value, 3);			//3 decimals digits
    ethbuff_ClientFlush();

    result = ethclient_FinishGetStream(eth_buffer, sizeof(eth_buffer), "NO ERR", TIMEOUT_CLIENT_CONNECTION, NO_KEEP_ALIVE);
  }
  else {
#if DEBUG_SERIAL == 1
    Serial.println(F("result: FAIL"));
#endif
    ethbuff_delay_and_stop();
  }


#if DEBUG_SERIAL_CLIENT == 1
  Serial.print(F("http_speed: ")); Serial.print((unsigned int)((unsigned long int)millis() - (unsigned long int)performance_start)); Serial.println(F("ms"));
#endif


  if (result) {
    push_success_cnt++;		//increment the counter of good push connection
    return true;
  }
  else {
    push_fail_cnt++;	   //increment the counter of bad push connection
    return false;
  }

}

bool  push_SendPush2(char *www_site, char *push_usr, char *arduino_name, char *type, char *msg, bool force)
{
  bool connected = false;
  byte retries = 0;
  if (!push_CheckPin() && force == false) {
    return 0;
  }

#if DEBUG_SERIAL == 1
  Serial.print(F("push_SendPush2: "));
#endif

  char *result = 0;


  //retries two times if connection is not estabilished
  while (!connected && retries < MAX_RETRIES_NUM) {
    if (retries > 0)
      ethbuff_delay_and_stop();
    connected = _client.connect(www_site, 80);
    retries++;
  }

  if (connected) {
#if DEBUG_SERIAL == 1
    Serial.println(F("result: PASS"));
#endif
    ethbuff_ClientClear();                  //clear the TX buffer before use it
    ethbuff_ClientPrint(F("GET /iws4_arduino/send_push.php?user="));
    ethbuff_ClientPrint(push_usr);
    ethbuff_ClientPrint(F("&pin="));
    ethbuff_ClientPrint(pin_push_flash);
    ethbuff_ClientPrint(F("&ardu="));
    ethbuff_ClientPrint(arduino_name);
    ethbuff_ClientPrint(F("&type="));
    ethbuff_ClientPrint(type);
    ethbuff_ClientPrint(F("&msg="));
    ethbuff_ClientPrint(msg);
    ethbuff_ClientFlush();

    result = ethclient_FinishGetStream(eth_buffer, sizeof(eth_buffer), "NO ERR", TIMEOUT_CLIENT_CONNECTION, NO_KEEP_ALIVE);
  }

  else {
#if DEBUG_SERIAL == 1
    Serial.println(F("result: FAIL"));
#endif
    ethbuff_delay_and_stop();
  }

  if (result) {
    push_success_cnt++;		//increment the counter of good push connection
    return true;
  }
  else {
    push_fail_cnt++;	   //increment the counter of bad push connection
    return false;
  }

}
