////////////////////////////////////////////////////////////////////////////////////////////////////
//ANDRUINO LIBRARY
//A.Scavuzzo
//www.andruino.it
//VAR
////////////////////////////////////////////////////////////////////////////////////////////////////

int server_port_number = 8888;

#if ARDUINO_2560MEGA == 1
#include <TimerOne.h>
//#include <TimerThree.h>
#include <avr/eeprom.h>

//WATCHDOG 
#include <avr/wdt.h>

#elif MCU_ESP8266 == 1
#include <Ticker.h>

#if OTA_ESP8266 == 1 && MCU_ESP8266 == 1
#include <ArduinoOTA.h>
#include <ESP8266WiFi.h>
#include <ESP8266mDNS.h>
#include <WiFiUdp.h>
#endif

Ticker Ticker_1sec;
Ticker Ticker_100ms;

#elif MCU_STM32 == 1
#if defined(TIM1)
  TIM_TypeDef *Instance = TIM1;
#else
  TIM_TypeDef *Instance = TIM2;
#endif
HardwareTimer *MyTim_runtime_10ms;
HardwareTimer *MyTim_startup_led_10ms;

volatile uint16_t timer1_count = 0;
unsigned int divider_timer1 = 100;


HardwareSerial Serial1(WIFI_ESP8266_SHIELD_RX_PIN, WIFI_ESP8266_SHIELD_TX_PIN);            //RX, TX serial used to communicate with esp8266 shield
#endif






#if ETHERNET_SHIELD == 1  || ETHERNET_SHIELD_V2 == 1
#if ETHERNET_SHIELD == 1
#include <Ethernet.h>
#endif
#if ETHERNET_SHIELD_V2 == 1
#include <Ethernet2.h>
#define W5200_CS  10
#endif

EthernetServer _server(server_port_number);
EthernetClient _client;
IPAddress IPAddress_device;
#endif

#if ARDUINO_MK1010_WIFI == 1
#include <WiFiNINA.h>
WiFiServer _server(server_port_number);
WiFiClient _client;
IPAddress IPAddress_device;
#endif


#if WIFI_ESP8266_SHIELD == 1
#include "WiFiEsp.h"
#define _ESPLOGLEVEL_ 2
WiFiEspServer _server(server_port_number);
WiFiEspClient _client;
IPAddress IPAddress_device;
#endif


#if MCU_ESP8266 == 1
#include <ESP8266WiFi.h>
//needed for library
#include <ESP8266WebServer.h>
#include <DNSServer.h>
#include <WiFiManager_andruino.h>          //https://github.com/tzapu/WiFiManager_andruino
WiFiManager_andruino WiFiManager_andruino;

WiFiServer _server(server_port_number);
WiFiClient _client;
IPAddress IPAddress_device;
#endif





#define ETH_TX_RX_MAX_PACKET 200

//************************************************************************************************//
//Array PINS/VAR/ANA
//************************************************************************************************
DigitalPin ArduinoIO[sizeof(base_digital_pins_used)];                            //DIGITAL INSTANCES (respect to the max pin in ANDRUINO_0DEFINES.h (open ANDRUINO library)
AnalogPin ArduinoAnalog[sizeof(base_analog_pins_used)];                         //ANALOG  INSTANCES (respect to the max pin in ANDRUINO_0DEFINES.h (open ANDRUINO library)
Variable Arduino_User_var[sizeof(base_variable_used)];         //ARDUINO VARIABLES setup (respect to the max pin in ANDRUINO_0DEFINES.h (open ANDRUINO library)


#if NRF24L_ENABLE == 1
//NRF24L UNIT MAX INSTANCES
SystemNRF24LPinsType SystemNRF24LPins[NRF24LMaxModules];  //NRF24L  setup (respect to the max pin in ANDRUINO_0DEFINES.h (open ANDRUINO library)
#endif


//************************************************************************************************//
//general variables/defines
//************************************************************************************************//


byte  seconds_counter = 0;
byte  seconds_counter_sensors = 0;
unsigned long int seconds_total = 0;
byte  minutes_counter = 0;
byte  hours_counter = 0;
byte  days_counter = 0;            //monday(1), tue(2), wed(3), thu(4), fri(5), sat(6), san(0)

unsigned long previousMillis = 0;
unsigned int  pairing_id = 0; //used to match Arduino and AndruinoApp ambient
unsigned int andruino_app_version = 0;


boolean check_limits_base = false;
boolean check_limits_NRF = false;
boolean check_sensor_minutes[10] = {true,true,true,true,true,true,true,true,true,true};
boolean check_sensor_seconds[10] = {true,true,true,true,true,true,true,true,true,true};

boolean check_DallasTemperature = true;
boolean en_DallasTemperature = false;

boolean check_power_consumption = false;
boolean check_timers = false;
boolean send_ping_req = true;
boolean send_http_active_client_req = false;
boolean send_http_notactive_client_req = true;

byte send_sensor_logger_scan = 0;

boolean msg_to_be_paired_push = false;
boolean msg_paired_push = false;
boolean store_sensor_eeprom = false;
boolean store_digital_out_eeprom = false;
boolean store_var_on_eeprom = false;


boolean nrf_radio_enable = false;
boolean nrf_radio_enable_rq = false;
boolean nrf_radio_disable_rq = false;
boolean nrf_radio_error_setup = false;

unsigned int connection_isfar = CONNECTION_FAR_IS;
unsigned int network_access = 0;
unsigned int network_client_access = 0;
boolean swap_timer = false;


unsigned long time1 = 0;
unsigned long time2 = 0;
byte push_success_cnt, push_fail_cnt, client_cumulated_fails_cnt, server_fail_cnt, server_fail_repeated_cnt = 0,  eth_restart_cnt = 0, client_consecutive_fails_cnt, client_fail_connected_cnt;


int pin_push_flash = 0;

char push_user [16];

char andruino_it_ip_address [42] = {'\0'};
char arduino_ip_address [] = "255.255.255.255\0";


char eth_buffer[ETH_TX_RX_MAX_PACKET];

bool global_set = false;

unsigned int  VCC_SUPPLY_BASE;
float ADC_STEP;

unsigned int http_server_performance_ms = 0;
unsigned int http_client_performance_ms = 0;
unsigned int http_client_performance_max_ms = 0;

boolean http_test_andruino_site = false;


unsigned int checksum_digital_vector = 0;


bool command_from_server_glo = false;

byte client_sendjson_active_req_every_sec = HTTP_SEND_JSON_ACTIVE_REQ_EVERY_SEC;
unsigned int client_sendjson_notactive_req_every_sec = HTTP_SEND_JSON_NOTACTIVE_REQ_EVERY_SEC;
unsigned int ping_req_every_sec = HTTP_SEND_PING_REQ_EVERY_SEC;


bool active_iphone_connection = false;

bool http_server_enabled = false;
byte watchdog_cnt = 0;
byte fault_restart = 0;
bool execute_client_commands = false;

byte eth_err_restart_persist = 0;
long int ethernet_id = -1;

bool restart_eth = false;
bool restart_board = false;
bool ap_enabled = false;
byte wifi_signal_bars = 0;

byte system_json_data_scan = 1;

bool station_connection_ok = false;       //false means that the ethernet/wifi connection was FAIL, true connection OK
bool access_point_connection_ok = false;              //false means that the AP connection was FAIL, true connection to AP is OK

//PWM light
int ramp_pwm = 0;
int ramp_max = 255;
int ramp_min = 5;
byte ramp_step = 4;
bool ramp_enable = false;
