////////////////////////////////////////////////////////////////////////////////////////////////////
//ANDRUINO LIBRARY
//A.Scavuzzo
//www.andruino.it
////////////////////////////////////////////////////////////////////////////////////////////////////


typedef enum keep_alive_type_e {NO_KEEP_ALIVE = 0, START_KEEP_ALIVE = 1, RUNNING_KEEP_ALIVE = 2};

#define PWM 2
#define P 2             //2 PWM
#define ALL 3
#define I INPUT         //0
#define O OUTPUT        //1



#define EEPROMSizeATmega168   512
#define EEPROMSizeATmega328   1024
#define EEPROMSizeATmega1280  4096
#define EEPROMSizeATmega32u4  1024
#define EEPROMSizeAT90USB1286 4096
#define EEPROMSizeMK20DX128   2048
#define EEPROMSizeMK20DX256   2048
#define EEPROMSizeATSAMD21G18 16384

#define EEPROMSizeUno         EEPROMSizeATmega328
#define EEPROMSizeUnoSMD      EEPROMSizeATmega328
#define EEPROMSizeLilypad     EEPROMSizeATmega328
#define EEPROMSizeDuemilanove EEPROMSizeATmega328
#define EEPROMSizePro         EEPROMSizeATmega328
#define EEPROMSizeFio         EEPROMSizeATmega328
#define EEPROMSizeMega        EEPROMSizeATmega1280
#define EEPROMSizeDiecimila   EEPROMSizeATmega168
#define EEPROMSizeNano        EEPROMSizeATmega168
#define EEPROMSizeTeensy2     EEPROMSizeATmega32u4
#define EEPROMSizeLeonardo    EEPROMSizeATmega32u4
#define EEPROMSizeMicro       EEPROMSizeATmega32u4
#define EEPROMSizeEsplora     EEPROMSizeATmega32u4
#define EEPROMSizeYun         EEPROMSizeATmega32u4
#define EEPROMSizeTre         EEPROMSizeATmega32u4
#define EEPROMSizeZero        EEPROMSizeATSAMD21G18
#define EEPROMSizeTeensy2pp   EEPROMSizeAT90USB1286
#define EEPROMSizeTeensy3     EEPROMSizeMK20DX128
#define EEPROMSizeTeensy31    EEPROMSizeMK20DX256


#if defined (__AVR_ATmega2560__)         //detect Arduino 2560
#warning "Arduino Mega selected"
#define ARDUINO_2560MEGA 1
#define MCU_ESP8266      0
#define MCU_STM32        0
#define BOARD_EEP_SIZE EEPROMSizeMega

#elif defined(ESP8266)                  //detect NODE MCU
#warning "ESP8266 selected"
#define MCU_ESP8266      1
#define ARDUINO_2560MEGA 0
#define MCU_STM32        0
#define ESP8266_EEPROM_SIZE 4096
#define BOARD_EEP_SIZE ESP8266_EEPROM_SIZE
#elif defined(ARDUINO_ARCH_STM32)                  //detect STM32
#warning "STM32 selected"
#define MCU_STM32        1
#define MCU_ESP8266      0
#define ARDUINO_2560MEGA 0
#define STM32_EEPROM_SIZE 4096
#define BOARD_EEP_SIZE STM32_EEPROM_SIZE

#elif defined(ARDUINO_SAMD_VARIANT_COMPLIANCE)
#warning "MKR selected"
#define MCU_STM32        0
#define MCU_ESP8266      0
#define ARDUINO_2560MEGA 0
#define ARDUINO_MKR      1
#define BOARD_EEP_SIZE EEPROMSizeMega

#else
#error "The selected board is not supported - ITA: la board selezionata non è supportata"
#endif
