////////////////////////////////////////////////////////////////////////////////////////////////////
//ANDRUINO LIBRARY
//A.Scavuzzo
//www.andruino.it
////////////////////////////////////////////////////////////////////////////////////////////////////


void eep_StoreDataToFlash();

//json_PerformRequestedCommand
//return 1 if the command is right
//return 0 if the command is unknown
void json_PerformRequestedCommand(bool command_from_server, byte index_cmd)
{
  unsigned int port_i;
  unsigned int action_i;
  unsigned int action2_i;
  unsigned int action3_i;
  unsigned int action4_i;          //used only in Limits and Pin
  unsigned int action5_i;          //used only in Limits and Pin

  //invalid command
  if (CmdQueue[index_cmd].cmd[0] == 0) {
    Serial.println(F("No cmds"));
    return;
  }

  port_i = atoi(CmdQueue[index_cmd].port);
  action_i = atoi(CmdQueue[index_cmd].action);
  action2_i = atoi(CmdQueue[index_cmd].action2);
  action3_i = atoi(CmdQueue[index_cmd].action3);
  action4_i = atoi(CmdQueue[index_cmd].action4);
  action5_i = atoi(CmdQueue[index_cmd].action5);

  ethbuff_ClientClear();                  //clear the TX buffer before use it


  command_from_server_glo =  command_from_server;

#if DEBUG_SERIAL_CMD == 1
  if (command_from_server == true) {
    Serial.print(F("\r\nCLIENT cmd="));
  }
  else
    Serial.print(F("\r\nDIRECT cmd="));
  Serial.print(CmdQueue[index_cmd].cmd); Serial.print(F("(port=")); Serial.print(CmdQueue[index_cmd].port); Serial.print(F(", action=")); Serial.print(CmdQueue[index_cmd].action); Serial.print(F(", action2=")); Serial.print(CmdQueue[index_cmd].action2); Serial.print(F(", action3=")); Serial.print(CmdQueue[index_cmd].action3); Serial.print(F(", action4=")); Serial.print(CmdQueue[index_cmd].action4); Serial.print(F(", action5=")); Serial.print(CmdQueue[index_cmd].action5); Serial.println(F(")"));
#endif

  //ArduinoIO
  //[self TX_Stream :c.write_cmd :DIGITAL_CH(port_i) :c.write_value(action) :@"0"(action2_i) :secondi_global(action3_i) :@"0"(action4_i) ];
  //port=2&action=1&action2=1&action3=2&action4=0
  //
  //NRF IO
  //[self TX_Stream :c.write_cmd :DIGITAL_CH(port_i) :c.write_value(action) :@"2"(action2_i) :NRF24LModuleIndex(action3_i) :secondi_global(action4_i)];


  //port_i= port number
  //action= high or low
  //action2_i=0 -- Arduino Base=0, Xbee=1, NRF24L=2
  //action3_i=XBee/NRF module number

  if (strcmp(CmdQueue[index_cmd].cmd, "DigWrite") == 0) {                              //write command is decoded
    //next time send the digital
    send_sensor_logger_scan = 0;

    //action2_i=0 -- Arduino IO
    if (action2_i == 0) {                                        //write on Arduino IO
      RemoteDigitalWrite(port_i, action3_i, CmdQueue[index_cmd].action);                   //write operation is performed (port_i=PIN, action3_i=duration if not 0, action=value)
      json_Arduino_SendAll(2);                                 //2 -- read Arduino IO and systems (digitals)
    }

#if NRF24L_ENABLE == 1
    //port_i= port number
    //action= high or low
    //action2_i=2 -- NRF24L IO enabled
    //action3_i=NRF24L module number
    else if (action2_i == 2) {
      RemoteDigitalWriteNRF24L(port_i, action_i, action3_i, action4_i);             //write operation is performed
      json_Arduino_SendAll(2);                                //2 -- read Arduino IO and systems (digitals
    }
#endif
  }

  else if (strcmp(CmdQueue[index_cmd].cmd, "DigSetup") == 0) {                                //write command is decoded
    store_digital_out_eeprom = true;
    //next time send the digital
    send_sensor_logger_scan = 0;
    //action2_i=0 -- Arduino IO
    if (action4_i == 0) {                                                 //write on Arduino IO
      //void RemoteDigitalSetup(byte indexV, byte mode, byte state, bool inv);
      RemoteDigitalSetup(port_i, action_i, action2_i, action3_i);
      json_Arduino_SendAll(2);                                 //2 -- read Arduino IO and systems (digitals)
    }
#if NRF24L_ENABLE == 1
    else {
      unsigned int index_nrf = action4_i - 100;                                //The NRF24L module number is action4_i - 100
      //void RemoteDigitalSetupNRF24L(uint8_t indexV, byte mode, uint8_t value, bool inv, byte indexModule);
      RemoteDigitalSetupNRF24L(port_i, action_i, action2_i, action3_i, action4_i);             //write operation is performed
      json_Arduino_SendAll(0);                                //2 -- read Arduino IO and systems (digitals
    }
#endif
  }

  //port_i=portA (motor1) min6 bit
  //action_i=activate A or B or not A and B (00, 01, 10)
  //action2_i=portB (motor2) min6 bit
  //action3_i=duration
  //action4_i=0 (Arduino_io or others)
  //


#if NRF24L_ENABLE == 1
  else if (strcmp(CmdQueue[index_cmd].cmd, "NRF24L") == 0) {                       //NRF24L command set

    //port_i= port number
    //action= high or low
    //action2_i=2 -- NRF24L IO enabled
    //action3_i=NRF24L module number
    RemoteCommandNRF24L(port_i, action_i, action2_i, action3_i, action4_i);
    //json_Arduino_SendAll(0);                                         //2 -- read Arduino IO and systems (digitals)

  }
#endif

  else if (strcmp(CmdQueue[index_cmd].cmd, "Blnd") == 0) {                       //Blind set
    //next time send the digital
    send_sensor_logger_scan = 0;
    if (action4_i == 0) {

      //find out_port on ArduinoIO array
      short index_array1 = json_SearchDigitalPin(sizeof(base_digital_pins_used), ArduinoIO, port_i, OUTPUT);
      short index_array2 = json_SearchDigitalPin(sizeof(base_digital_pins_used), ArduinoIO, action2_i, OUTPUT);
      if (index_array1 >= 0 && index_array2 >= 0) {
        if (action_i == 0) {                                //activate port A and disactivate port B
          writeDig(ArduinoIO[index_array2], false);
          delay(1000);
          writeDig(ArduinoIO[index_array1], true);
          ArduinoIO[index_array1].time_counter = action3_i;
        } else if (action_i == 1) {                        //activate port B and disactivate port A
          writeDig(ArduinoIO[index_array1], false);
          delay(1000);
          writeDig(ArduinoIO[index_array2], true);
          ArduinoIO[index_array2].time_counter = action3_i;
        } else {                                           //disactivate port B and A
          writeDig(ArduinoIO[index_array1], false);
          writeDig(ArduinoIO[index_array2], false);
        }
      }
    }
    json_Arduino_SendAll(2);								//2 -- read Arduino IO and systems (digitals)

  } else if (strcmp(CmdQueue[index_cmd].cmd, "PwmWrite") == 0) {                       //PWM write command is decoded
    //next time send the digital
    send_sensor_logger_scan = 0;
    short index_array = json_SearchDigitalPin(sizeof(base_digital_pins_used), ArduinoIO, port_i, PWM);
    if (index_array >= 0) {
      writePWM(ArduinoIO[index_array], action_i);
      json_Arduino_SendAll(2);									//2 -- read Arduino IO and systems (digitals)
      store_digital_out_eeprom = true;
    }

  } else if (strcmp(CmdQueue[index_cmd].cmd, "VarWrite") == 0) {                      //Var write command is decoded

    Arduino_User_var[port_i].value = (float)action_i / 10;      //var are trasmitted by 100 using int
    json_Arduino_SendAll(0);									//0 -- read all
    store_var_on_eeprom = true;
  }


  //&cmd=LimAna&port=4&action=10&action2=20&action3=1&action4=0
  //port= arduino resource (DIG0, ANA0, etc)
  //action=max limit
  //action2=low limit
  //action3 enable or disable the limit check
  //action4_i=0 -- arduino IO
  //action4_i=100 -- NRF module 0
  //action4_i=101 -- NRF module 1
  else if (strcmp(CmdQueue[index_cmd].cmd, "LimAna") == 0) {                          //download the limit for each sensor
    //action4=0  Local Arduino
    if (action4_i == 0) {                                       //Arduino_io Analogs is action4_i=0
      ArduinoAnalog[port_i].max = action_i;                   //action=max limit
      ArduinoAnalog[port_i].min = action2_i;                  //action2=min limit
      ArduinoAnalog[port_i].enable_limits = action3_i;        //action3 enable or disable the limit check
      ArduinoAnalog[port_i].Limit.max_events = action5_i;        //max events
    }

#if NRF24L_ENABLE == 1
    else {                                                                    //NRF24L Analogs is action4_i not 0 (starts from 100)
      unsigned int index_nrf = action4_i - 100;                                //The NRF24L module number is action4_i - 100
      SystemNRF24LPins[index_nrf].AnaPin[port_i].max = action_i;             //action=max limit
      SystemNRF24LPins[index_nrf].AnaPin[port_i].min = action2_i;            //action2=min limit
      SystemNRF24LPins[index_nrf].AnaPin[port_i].enable_limits = action3_i;  //action3 enable or disable the limit check
      SystemNRF24LPins[index_nrf].AnaPin[port_i].Limit.max_events = action5_i;

    }
#endif
    json_Arduino_SendAll(0);									//read all data

  } else if (strcmp(CmdQueue[index_cmd].cmd, "LimDig") == 0) {                        //download the limit for each sensor
    short index_array = json_SearchDigitalPin(sizeof(base_digital_pins_used), ArduinoIO, port_i, INPUT);
    if (action4_i == 0 && index_array >= 0) {                                     //Arduino Dig is action4_i=0
      ArduinoIO[index_array].alarm = action_i;                     //action=alarm
      ArduinoIO[index_array].enable_limits = action3_i;            //action3 enable or disable the limit check
      ArduinoIO[index_array].Limit.max_events = action5_i;

    }

#if NRF24L_ENABLE == 1
    else {                                                                   //NRF24L Dig is action4_i not 0 (starts from 100)
      unsigned int index_nrf = action4_i - 100;                                       //The NRF24L module number is action4_i - 100
      //index_nrf:0, action_i:0(alarm on state low), action3_i:111 (push enable bit0, out enabled, bit1, bit(7:2) output  number=27)
      ///IO.json?user=arduino2&pass=andrea&cmd=LimDig&port=4&action=0&action2=0&action3=111&action4=100
      //index_nrf:0, action_i:0, action3_i:111, port_i:4

      //the NRF io index PIN doesn't follow the vector index (the pin can start from 4 and the vector start from 0)

      short index_vector = json_SearchDigitalPin (NRF24LMaxDigitalPin, SystemNRF24LPins[index_nrf].DigPin, port_i, INPUT);
      if (index_vector >= 0) {
        //Serial.print(F("index_nrf:"));Serial.print(index_nrf);Serial.print(F(", action_i:"));Serial.print(action_i);Serial.print(F(", action3_i:"));Serial.print(action3_i);Serial.print(F(", port_i:"));Serial.print(port_i);Serial.print(F(", index_vector:"));Serial.print(index_vector);Serial.println(F(""));
        SystemNRF24LPins[index_nrf].DigPin[index_vector].alarm = action_i;             //action=max limit
        SystemNRF24LPins[index_nrf].DigPin[index_vector].enable_limits = action3_i;  //action3 enable or disable the limit check
        SystemNRF24LPins[index_nrf].DigPin[index_vector].Limit.max_events = action5_i;

      }
    }
#endif
    json_Arduino_SendAll(0);									//read all data

  }
  else if (strcmp(CmdQueue[index_cmd].cmd, "LimVar") == 0) {                          //download the limit for each var
    if (action4_i == 0) {                                         //Arduino Dig is action4_i=0
      store_var_on_eeprom = true;
      Arduino_User_var[port_i].max = action_i;                    //action=max limit
      Arduino_User_var[port_i].min = action2_i;                   //action2=min limit
      Arduino_User_var[port_i].enable_limits = action3_i;         //action3 enable or disable the limit check
      Arduino_User_var[port_i].Limit.max_events = action5_i;

    }
#if NRF24L_ENABLE == 1
    else {                                                                    //NRF24L vars is action4_i not 0 (starts from 100)
      unsigned int index_nrf = action4_i - 100;                                        //The NRF24L module number is action4_i - 100
      SystemNRF24LPins[index_nrf].VarPin[port_i].max = action_i;             //action=max limit
      SystemNRF24LPins[index_nrf].VarPin[port_i].min = action2_i;            //action2=min limit
      SystemNRF24LPins[index_nrf].VarPin[port_i].enable_limits = action3_i;  //action3 enable or disable the limit check
      SystemNRF24LPins[index_nrf].VarPin[port_i].Limit.max_events = action5_i;

    }
#endif

    json_Arduino_SendAll(0);                  //read all data
  }


  //PORT_I= timer number

  //8 bits on action_i: out port: -- 6 bits

  //TIMER CONFIGURATION: action2 (16 bit) & action3 (16 bit)
  //action2_i
  //week: bit[6:0] S-F-T-W-T-M-S -- 7 bit (0 if is selected, 1 if is unselected, 1111111=means not used)
  //repeat: bit[7]  -- 1 bit
  //hour: bit[12:8] 0-23 -- 5 bit
  //NU: bit[13]  -- 1 bit
  //NU: bit[14]  -- 1 bit
  //NU: bit[15]  -- 1 bit

  //action3_i
  //min: bit[3:0] 5 min -- 4 bit (12)
  //duration: bit[11:4] 5 min for each hour (max 8)  -- 4+4=8  bit
  //NU: bit[15:12]  -- 4 bit

  //5 bytes for each timer

  //action2_i=0x0055 (85)
  //week: 0x55 -- 01010101 (0, SATURDAY(YES), FRIDAY, THURSDAY(YES), WEDNESDAY, TUESDAY(YES), MONDAY, SUNDAY(YES))
  //hour: 0x0 -- 0 hour
  //
  //action3_i=0x065 (101)
  //min: 0x5 -- 5 -- 5*5=25 minutes
  //duration: 0x6, 6*5=30min and 0 hours -- 0 hours and 30minutes
  //http://192.168.1.15:8888/IO.json?user=arduino&pass=andrea&cmd=Tmr&port=0&action=7&action2=85&action3=101&action4=0
  else if (strcmp(CmdQueue[index_cmd].cmd, "Tmr") == 0) {                            //timers setting
    //port_i: -- timer number
    //action_i -- output port
    //action2+action3 -- 32BITS: timer config start + stop
    uint16_t address;
    address = FLA_TIMERS_ADDRESS + (BYTES_FOR_EACH_TIMER * port_i);
    //timer number -- address index
    //ACTION (week + port_num): repeat + week bit  (8bit) + port number (8 bit)
    //ACTION2 (min + hour):  minute bit (8 bit) + hour bit (8 bit)
    //ACTION3 (min stop + hour stop): minute stop bit (8 bit) + hour start bit (8 bit)
    //ACTION4 (pwm stop value + pwm start value): pwm stop start, pwm start (8 + 8)

    eeprom_write_wordNEW (address, action_i);                           //port number (8 bit) + repeat + week bit  (8bit)
    eeprom_write_wordNEW ((address + 2), action2_i);                    //hour bit (8 bit) + minute bit (8 bit) 
    eeprom_write_wordNEW ((address + 4), action3_i);                    //hour stop bit (8 bit) + minute stop bit (8 bit) 
    eeprom_write_wordNEW ((address + 6), action4_i);                    //pwm start start, pwm stop 8 + 8 

    json_Arduino_SendAll(2);                                                                          //actions -- see below json_Arduino_SendAll descriptions (read only systems)
  }

  //http://192.168.1.15:8888/IO.json?user=arduino&pass=andrea&cmd=ReadAll&port=0&action=0&action2=0&action3=0&action4=0           //read all sensors
  else if (strcmp(CmdQueue[index_cmd].cmd, "ReadAll") == 0) {                         //Read All command is decoded
    json_Arduino_SendAll(action3_i);						     //actions -- see below json_Arduino_SendAll descriptions
  }

  //http://192.168.1.15:8888/IO.json?user=arduino2&pass=andrea&cmd=ReadDigOne&port=3&action=0&action2=0&action3=0&action4=0          //read one sensor details
  else if (strcmp(CmdQueue[index_cmd].cmd, "ReadDigOne") == 0) {                         //Read  is decoded
    if (action2_i == 0) {                                        //write on Arduino IO
      short index_array = json_SearchDigitalPin(sizeof(base_digital_pins_used), ArduinoIO, port_i, ALL);
      if (index_array >= 0)
        json_Arduino_DigitalSingle(ArduinoIO, index_array);
      else
        json_error(10);
    }
#if NRF24L_ENABLE == 1
    else if (action2_i == 2) {
      //port_i= port number
      //action= not used
      //action2_i=2 -- NRF24L IO enabled
      //action3_i=NRF24L module number
      short index_array = json_SearchDigitalPin (NRF24LMaxDigitalPin, SystemNRF24LPins[action3_i].DigPin, port_i, ALL);
      if (index_array >= 0)
        json_Arduino_DigitalSingle(SystemNRF24LPins[action3_i].DigPin, index_array);
      else
        json_error(10);
    }
#endif
  }
  //http://192.168.1.15:8888/IO.json?user=arduino2&pass=andrea&cmd=ReadAnaOne&port=3&action=0&action2=0&action3=0&action4=0          //read one sensor details
  else if (strcmp(CmdQueue[index_cmd].cmd, "ReadAnaOne") == 0) {                         //Read  is decoded
    if (action2_i == 0) {                                        //write on Arduino IO
      json_Arduino_AnalogSingle(ArduinoAnalog, port_i);
    }
#if NRF24L_ENABLE == 1
    else if (action2_i == 2) {
      //port_i= port number
      //action= not used
      //action2_i=2 -- NRF24L IO enabled
      //action3_i=NRF24L module number
      json_Arduino_AnalogSingle(SystemNRF24LPins[action3_i].AnaPin, port_i);
    }
#endif
  }
  //http://192.168.1.15:8888/IO.json?user=arduino2&pass=andrea&cmd=ReadAnaOne&port=3&action=0&action2=0&action3=0&action4=0          //read one sensor details
  else if (strcmp(CmdQueue[index_cmd].cmd, "ReadVarOne") == 0) {                         //Read  is decoded
    if (action2_i == 0) {                                        //write on Arduino IO
      json_Arduino_VariableSingle(Arduino_User_var, port_i);
    }
#if NRF24L_ENABLE == 1
    else if (action2_i == 2) {
      //port_i= port number
      //action= not used
      //action2_i=2 -- NRF24L IO enabled
      //action3_i=NRF24L module number
      json_Arduino_VariableSingle(SystemNRF24LPins[action3_i].VarPin, port_i);
    }
#endif
  }
  //http://192.168.1.15:8888/IO.json?user=arduino&pass=andrea&cmd=sync&port=0&action=0&action2=0&action3=0&action4=65000           //read all sensors
  else if (strcmp(CmdQueue[index_cmd].cmd, "sync") == 0) {                             //sync date & reset timers if the first time
    seconds_counter = port_i;
    minutes_counter = action_i;
    hours_counter = action2_i;
    days_counter = action3_i;

    //send all the system data
    system_json_data_scan = 1;

    //if action4_i>0 means that a new hw board is found, so clear all the flash locations
    if (action4_i > 0) {
      msg_paired_push = true;
      eeprom_write_wordNEW ((FLA_ANDRUINO_PAIRING_ID_ADDRESS), action4_i);                                          //write the Andruino App ID on flash


      //erase all timers
      for (int index = 0; index < MAX_TIMERS; index++) {
        eeprom_write_byteNEW ((FLA_TIMERS_ADDRESS + BYTES_FOR_EACH_TIMER * index), 255);                    //reset all the timers
        delay(10);
      }

      //reset all the IO and all the nofification enabled
      // TO BE DONE

      //update pairing_id vars
      pairing_id = action4_i;

#if DEBUG_SERIAL == 1
      Serial.println(F("Board is paired"));
#endif
    }

    json_Arduino_SendAll(6);                                    //actions -- see below json_Arduino_SendAll descriptions (read only systems)
  }
  //http://192.168.1.15:8888/IO.json?user=arduino&pass=andrea&cmd=sync&port=0&action=0&action2=0&action3=0&action4=65000           //read all sensors
  else if (strcmp(CmdQueue[index_cmd].cmd, "sync2") == 0) {                             //sync date & reset timers if the first time

    eeprom_write_wordNEW ((FLA_ANDRUINO_VERSION), port_i);    //write the Andruino App version on flash
    andruino_app_version = port_i;
    json_Arduino_SendAll(6);
  }
  //http://10.0.1.15:8888/IO.json?user=arduino&pass=andrea&cmd=Pin&port=2000&action=0&action2=0&action3=0&action4=1               //push test and pin update
  //http://10.0.1.15:8888/IO.json?user=arduino&pass=andrea&cmd=Pin&port=2000&action=0&action2=0&action3=0&action4=0               //pin update
  else if (strcmp(CmdQueue[index_cmd].cmd, "Pin") == 0) {                             //Store the USER and PIN
    /*    int old_pin = pin_push_flash;
        char board_name_array_temp[20];
        memcpy(board_name_array_temp, board_name_array, sizeof(board_name_array));
        //email: CmdQueue[index_cmd].action
        //pin: port_i
        eep_Set_Andruino_user_default_parameters(CmdQueue[index_cmd].action, port_i, board_name_array_temp, server_port_number);

    */
    //read Andruino ID
    pairing_id = eeprom_read_wordNEW ((FLA_ANDRUINO_PAIRING_ID_ADDRESS));	 //read the Andruino App ID from flash

    /*    if (action4_i  == 1 || old_pin != pin_push_flash) {          //send a notification if the pin is new or as a new request
          msg_to_be_paired_push = true;                                      //send a TEST push notification
        }
    */
    store_sensor_eeprom = true;
    json_Arduino_SendAll(6);                                       //actions -- see below json_Arduino_SendAll descriptions (read only systems)
  }
  //http://10.0.1.17:8080/IO.json?user=arduino2&pass=andrea&cmd=AndIP&port=0&action=andruino2.it&action2=0&action3=0
  else if (strcmp(CmdQueue[index_cmd].cmd, "AndIP") == 0) {                                       //Store the AndruinoIP
    //Store andruino.it address
    if (eep_Write_Andruino_it_address(CmdQueue[index_cmd].action))  {
      json_Arduino_SendAll(6);                                        //actions -- see below json_Arduino_SendAll descriptions (read only systems)
    }
  }

  //CLIENT cmd=ClientSet(port=0, action=2, action2=60, action3=0, action4=60, action5=0)
  //http://10.0.1.17:8080/IO.json?user=arduino2&pass=andrea&cmd=ClientSet&port=0&action=2&action2=15&action3=2&action4=60
  else if (strcmp(CmdQueue[index_cmd].cmd, "ClientSet") == 0) {                                       //Store the AndruinoIP

    if (action_i < 60 && action_i > 0)                        //DATA ACTIVE from 1 to 59 (default is 2)
      client_sendjson_active_req_every_sec = action_i;
    if (action2_i < 3600 && action2_i > 2) {                    //PING TIME from 3 to 3600 (default is 15)
      ping_req_every_sec = action2_i;
      if(action2_i > action4_i)
        action4_i = action2_i;
    }
    if (action4_i >= 0)
      client_sendjson_notactive_req_every_sec = action4_i;      //DATA NOT ACTIVE from 1 to 65535 (default is 60, 0 is disabled)

    eep_Write_HttpRequest_time();
    json_Arduino_SendAll(6);
  }

  //http://192.168.1.15:8888/IO.json?user=arduino&pass=andrea&cmd=fnct&port=0&action=0&action2=0&action3=0&action4=0              //reset Arduino
  else if (strcmp(CmdQueue[index_cmd].cmd, "fnct") == 0) {
    switch (port_i) {
      case 1:
        function1(CmdQueue[index_cmd].action, CmdQueue[index_cmd].action2, CmdQueue[index_cmd].action3, CmdQueue[index_cmd].action4);
        break;
      case 2:
        function2(CmdQueue[index_cmd].action, CmdQueue[index_cmd].action2, CmdQueue[index_cmd].action3, CmdQueue[index_cmd].action4);
        break;
      case 3:
        function3(CmdQueue[index_cmd].action, CmdQueue[index_cmd].action2, CmdQueue[index_cmd].action3, CmdQueue[index_cmd].action4);
        break;
      default:
        break;
    }
  }
  else if (strcmp(CmdQueue[index_cmd].cmd, "System") == 0) {
    switch (port_i) {
      //RESET
      case 0:
        if (action_i == 55)
          Restart(false, false);         //true, increment in flash the fault counter, false don't increment, false NOT SILENT
        break;
      //Store all the variables ans system to flash
      case 1:
        if (action_i == 55)
          store_sensor_eeprom = true;             //activate the process that store all the ram on flash
        break;
      //Store all the variables ans system to flash
      case 2:
        if (action_i == 55)
          restart_eth = true;             //restart eth
        break;
      case 3:
        if (action_i == 56) {
          eeprom_write_byteNEW ((FLA_FORCE_CAPTIVE_ADDRESS), 0);
          Restart(false, false);         //true, increment in flash the fault counter, false don't increment, false NOT SILENT
        }
        break;
      case 4:
        //enable or disable the continuous AP
        if (action_i == 57) {
          eeprom_write_byteNEW ((FLA_AP_ENABLED_ADDRESS), action2_i);               //0 AP disabled, 1 AP disabled
          Restart(false, false);         //true, increment in flash the fault counter, false don't increment, false NOT SILENT
        }
        break;
      default:
        break;
    }

  }
  else if (strcmp(CmdQueue[index_cmd].cmd, "Flash") == 0) {
    switch (port_i) {
      //ERASE ALL FLASH to 0 and PROGRAM THE DEFAULT (doesn't erase pin and user)
      case 0:
        if (action_i == 55)
          eep_EraseDefaultFlash (false);
        msg_to_be_paired_push = true;
        break;
      case 1:
        //PROGRAM PART OF FLASH from Add to Add
        for (unsigned int i = action_i; i <= action2_i; i++) {
          eeprom_write_byteNEW (i, action3_i);
          if (!command_from_server_glo)
            _client.print("A:"); _client.print(i); _client.print(",Set: "); _client.println(action3_i);
        }
        break;
      //READ from Add to Add
      //http://10.0.1.18:8872/IO.json?user=Spina2&pass=andrea&cmd=Flash&port=2&action=600&action2=760&action3=0
      case 2:
        _client.print(F("Print from:")); _client.print(action_i); _client.print(F(",to:")); _client.println(action2_i);
        for (unsigned int i = action_i; i <= action2_i; i++) {
          uint8_t tmp;
          tmp = eeprom_read_byteNEW (i);
          _client.print(F("A:")); _client.print(i); _client.print(F(",Read:")); _client.println(tmp);
        }
        break;
      //store all the data to flash
      case 3:
        if (action_i == 55)
          eep_StoreDataToFlash();
        break;
      case 4:
        if (action_i == 59)
          eep_EraseDefaultFlash (true);
        break;
      case 5:
        if (action_i == 69)
          //erase all timers
          for (int index = 0; index < MAX_TIMERS; index++) {
            eeprom_write_byteNEW ((FLA_TIMERS_ADDRESS + BYTES_FOR_EACH_TIMER * index), 255);                    //reset all the timers
            delay(10);
          }
        break;

      //http://192.168.1.112:8881/IO.json?user=nodeMCU1&pass=andrea&cmd=Flash&port=6&action=79&action2=ssid&action3=pass
      case 6:
        if (action_i == 79) {
#if ETHERNET_SHIELD == 0 && ETHERNET_SHIELD_V2 == 0
          Serial.println(F("Wifi SSID and PSW update"));
          char ssid_station_char[SSID_LENGHT] = {'\0'};
          char pass_station_char[PASS_LENGHT] = {'\0'};
          eeprom_write_blockNEW(ssid_station_char, FLA_SSIDWIFI_ADDRESS, SSID_LENGHT);
          eeprom_write_blockNEW(pass_station_char, FLA_PASSWIFI_ADDRESS, PASS_LENGHT);
          eeprom_write_blockNEW(CmdQueue[index_cmd].action2, FLA_SSIDWIFI_ADDRESS, strlen(CmdQueue[index_cmd].action2));
          eeprom_write_blockNEW(CmdQueue[index_cmd].action3, FLA_PASSWIFI_ADDRESS, strlen(CmdQueue[index_cmd].action3));
          Restart(false, false);         //true, increment in flash the fault counter, false don't increment, false NOT SILENT
#endif         
        }
        break;
      default:
        break;
    }

  }
            
  else {
    json_Arduino_SendAll(0);									//read all data
  }

  if (!command_from_server_glo)
    ethbuff_ClientFlush();
}
