
////////////////////////////////////////////////////////////////////////////////////////////////////
//ANDRUINO LIBRARY
//A.Scavuzzo
//www.andruino.it
//ETH BUFFER
////////////////////////////////////////////////////////////////////////////////////////////////////


void ftoa_andrea(float val, char *val_char);


//#if ETH_BUFFER_MAX_PACKET > ETH_TX_RX_MAX_PACKET
//#error "ETH_BUFFER_MAX_PACKET can't be over ETH_TX_RX_MAX_PACKET"
//#endif

unsigned long int tempo1 = 0;


void ethbuff_ClientPrint(char* new_buffer) {

  int lungh_buff = strlen(eth_buffer);
  int lungh_char = strlen(new_buffer);
#if DEBUG_SERIAL_HTTP_TRASMIT == 1
  tempo1 = millis();
  //  Serial.print("lungh_buff:"); Serial.print(lungh_buff); Serial.print(" lungh_char:"); Serial.print(lungh_char); Serial.print(" TOT:"); Serial.println((lungh_buff + lungh_char));
#endif
  if ((lungh_buff + lungh_char) > ETH_TX_RX_MAX_PACKET - 5) {

    //  _client.write(eth_buffer);          //tx the previous
    _client.print(eth_buffer);          //tx the previous

#if DEBUG_SERIAL_HTTP_TRASMIT == 1
    Serial.print(F("-- Print buffer size (: ")); Serial.print(lungh_buff); Serial.print(F("): ")); Serial.print(eth_buffer); Serial.print(F(" -- time: ")); Serial.print(millis() - tempo1); Serial.println(F(" ms"));
#endif
    strcpy (eth_buffer, new_buffer);   //store the newone in the buffer for next tx
    if (lungh_buff > ETH_TX_RX_MAX_PACKET - 5)
      Serial.println(F("ERR"));

#if DELAY_TX_ETHERNET != 0
    delay(DELAY_TX_ETHERNET);
#endif
  }

  else {
    strcat (eth_buffer, new_buffer);
  }
}



void ethbuff_ClientPrintln(const __FlashStringHelper* new_buffer) {

  ethbuff_ClientPrint(new_buffer);
  ethbuff_ClientPrint(F("\r\n"));
}

void ethbuff_ClientPrint(const __FlashStringHelper* new_buffer) {
  char temp[50];
  memset(temp, 0, sizeof(temp));
  byte size = strlen_P((char*)new_buffer);
  memcpy_P(temp, new_buffer, size);
  temp[size] = '\0';
  ethbuff_ClientPrint(temp);
}


void ethbuff_ClientPrintln(char* new_buffer) {
  ethbuff_ClientPrint(new_buffer);
  ethbuff_ClientPrint(F("\r\n"));
}

void ethbuff_ClientPrint(int integer) {
  ethbuff_ClientPrint(integer, 0);
}
void ethbuff_ClientPrintln(int integer) {
  ethbuff_ClientPrint(integer);
  ethbuff_ClientPrint(F("\r\n"));
}



void ethbuff_ClientPrint(int integer, int base) {
  char new_buffer[10];
  if (base == HEX)  {
    sprintf(new_buffer, "%X", integer);
  }
  else if (base == OCT)  {
    sprintf(new_buffer, "0%o", integer);
  }
  else {
    sprintf(new_buffer, "%d", integer); //AndreaS
  }
  ethbuff_ClientPrint(new_buffer);
}

void ethbuff_ClientPrintln(int integer, int base) {
  ethbuff_ClientPrint(integer, base);
  ethbuff_ClientPrint(F("\r\n"));
}

void ethbuff_ClientPrint(float floating, int digit) {

  //bug fix July 2016
  char new_buffer[15] = {'\0'};
  //char *   dtostrf (double __val, signed char __width, unsigned char __prec, char *__s)
  //width=precision+1+number of char of interger

  //bug fix July 2016
  if (floating > 67108864 ) //2^26
    floating = 67108864;


  //65000.000 are needed 9 char
  /*
    #if ARDUINO_2560MEGA == 1
         dtostrf(floating, digit+2, digit, new_buffer);
    #else*/


  ftoa_andrea(floating, new_buffer);
  //#endif

  ethbuff_ClientPrint(new_buffer);
  // Serial.print("float:"); Serial.println(new_buffer);


}
void ethbuff_ClientPrintln(float floating, int digit) {
  ethbuff_ClientPrint(floating, digit);
  ethbuff_ClientPrint(F("\r\n"));
}

void ethbuff_ClientPrintln() {
  ethbuff_ClientPrint(F("\r\n"));
}


void ethbuff_ClientFlush() {

  int lungh_buff = strlen(eth_buffer);

  if (lungh_buff > 0) {

#if  MCU_ESP8266 == 1 || MCU_STM32 == 1
    _client.print(eth_buffer);          //tx the previous
#else
    _client.write(eth_buffer);          //tx the previous
#endif
#if DEBUG_SERIAL_HTTP_TRASMIT == 1
    Serial.print(F("--- remaining buffer: ")); Serial.println(eth_buffer);
#endif
  }
  ethbuff_ClientClear();

}

void ethbuff_ClientClear() {
  memset(eth_buffer, 0, sizeof(eth_buffer));
  //strcpy (eth_buffer, "");
}

void ethbuff_delay_and_stop() {
  delay(200);
  _client.flush();
  _client.stop();
  //delay(200);
}
