////////////////////////////////////////////////////////////////////////////////////////////////////
//ANDRUINO LIBRARY
//A.Scavuzzo
//www.andruino.it
//SET CONFIG
////////////////////////////////////////////////////////////////////////////////////////////////////


//Ethernet interfaces or board name
//(select only one of them)
//see http://andruino.it/connections/


/////////////////////////////////////
//ETHERNET SHIELDS for ARDUINO_2560MEGA
/////////////////////////////////////

//Arduino MEGA boards with ethernet shield (W5100 and W5200)
//this option will be used when ARDUINO_2560MEGA is selected on the board list
#define ETHERNET_SHIELD             0                               //Ethernet shield enabled (classic module)
#define ETHERNET_SHIELD_V2          1                               //Ethernet shield V2 enabled

/////////////////////////////////////
//WIFI SHIELDS for ARDUINO_2560MEGA and STM32
/////////////////////////////////////
//Arduino MEGA or STM32 boards with esp8266 as wifi shield
#define WIFI_ESP8266_SHIELD         0                               //ESP8266 Wifi shield enabled






/////////////////////////////////////
//BOARDS STANDALONE WITH WIFI EMBEDDED
/////////////////////////////////////


//not yet avaiable
//not yet avaiable
#define ARDUINO_MK1010_WIFI         0


//ESP8266 board (MCU esp8266, all in one)
#define ESP8266_01_GENERIC          0                               //Board ArduinoIDE option: Generic ESP8266-01 module
#define NODE_MCU                    0                               //Board ArduinoIDE option: NodeMCU 1.0
#define ESP8266_12E_CONF2           0                               //Board ArduinoIDE option: ESP12E, Generic ESP8266, configure flash 512K: fs: 32, ota: 230
#define WEMOS_D1_MINI               0                               //Board ArduinoIDE option: Wemos select
#define SONOFF_BASIC                0                               //Board ArduinoIDE option: Generic ESP8266 Module with DOUT option enabled
#define SONOFF_S20                  0                               //Board ArduinoIDE option: Generic ESP8266 Module with DOUT option enabled
#define SONOFF_TH10                 0                               //Board ArduinoIDE option: Generic ESP8266 Module with DOUT option enabled


//ENABLE OTA (only for board based on ESP8266)
#define OTA_ESP8266                 1                               //ArduinoIDE OTA with esp8266, can be used only with: ESP8266_01_GENERIC,NODE_MCU,ESP8266_12E_CONF2,SONOFF


/////////////////////////////////////
//STM32 MCU nucleo board (you have to enable WIFI_ESP8266_SHIELD for wifi)
/////////////////////////////////////
#define STM32_NUCLEO_64             0                               //tested on Nucleo 64 pin L476RG
#define STM32_NUCLEO_32             0                               //tested on Nucleo 32 pin L432KC



//SLEEP MODE only for ESP8266 (ESP8266_01_GENERIC,NODE_MCU,ESP8266_12E_CONF2,SONOFF)
#define SLEEP_MODE                  0
#define SLEEP_WAKEUP_MIN            10                              //minutes
