////////////////////////////////////////////////////////////////////////////////////////////////////
//ANDRUINO LIBRARY
//A.Scavuzzo
//www.andruino.it
////////////////////////////////////////////////////////////////////////////////////////////////////


#if SONOFF_TH10 == 1                                      //Temperature/Humidity sensor DHT11/22 (uses ONE wire bus)
#include "DHT.h"
#define DHTTYPE SI7021_1W
#define DHT_PIN 14
DHT dht(DHT_PIN, DHTTYPE);
#endif


#if THERMO_ADAFRUIT_DHT == 1                             //Temperature/Humidity sensor DHT11/22 (uses ONE wire bus)
#include <DHT.h>
DHT dht(DHT_PIN, DHTTYPE);
#if THERMO_ADAFRUIT_DHT2 == 1                             //second DHT sensor
DHT dht2(DHT2_PIN, DHTTYPE);                               //secon DHT sensor
#endif
#endif


#if THERMO_ADAFRUIT_MAX31855 == 1                       //Temperature sensor (uses SPI bus)
#include <Adafruit_MAX31855.h>
int thermoDO = 3;                                       //soft SPI Data output=PIN3 (SO)
int thermoCS = 4;                                       //soft SPI Chip select=PIN4 (CS)
int thermoCLK = 5;                                      //soft SPI Clock =PIN5 (SCK)
Adafruit_MAX31855 thermocouple(thermoCLK, thermoCS, thermoDO);
#endif


#if Dallas_DS18B20 >0                                 //Dallas DS18B20 Temperature sensor
#include <OneWire.h>
#include <DallasTemperature.h>
OneWire oneWire(ONE_WIRE_BUS);                          // Setup a oneWire instance to communicate with any OneWire devices (not just Maxim/Dallas temperature ICs)
DallasTemperature sensors(&oneWire); // Pass our oneWire reference to Dallas Temperature.
DeviceAddress tempDeviceAddress[Dallas_DS18B20-1];
#endif


#if THERMO_SHT1x == 1                                   //SHT1x series (SHT10, SHT11, SHT15) and SHT7x series (SHT71, SHT75) temperature / humidity sensors from Sensirion, http://www.sensirion.com. 
#include <SHT1x.h>
// Specify data and clock connections and instantiate SHT1x object
SHT1x sht1x(THERMO_SHT1x_DATAPIN, THERMO_SHT1x_CLOCKPIN);
#endif


#if NUCLEO_SHIELD_IKS01A1 == 1
#define THERMO_HTS221       1
#define THERMO_HUM_LPS25HB  1
#define GYRO_ACC_LSM6DS0    1
#define MAGNETO_LIS3MDL     1
#elif NUCLEO_SHIELD_IKS01A2 == 1
#define THERMO_HTS221       1
#define THERMO_HUM_LPS22HB  1
#define GYRO_ACC_LSM6DSL    1
#define MAGNETO_ACC_LSM303  1
#endif


#if THERMO_HTS221 == 1
#include <HTS221Sensor.h>
#define DEV_I2C Wire
HTS221Sensor  *HumTemp_HTS221;
#endif

#if THERMO_HUM_LPS25HB == 1
#include <LPS25HBSensor.h>
#define DEV_I2C Wire
LPS25HBSensor *PressTemp_LPS;
#elif THERMO_HUM_LPS22HB == 1
#include <LPS22HBSensor.h>
#define DEV_I2C Wire
LPS22HBSensor *PressTemp_LPS;
#endif

#if GYRO_ACC_LSM6DS0 == 1
#include <LSM6DS0Sensor.h>
#define DEV_I2C Wire
LSM6DS0Sensor *AccGyr_LSM6DS;
#elif GYRO_ACC_LSM6DSL == 1
#include <LSM6DSLSensor.h>
#define DEV_I2C Wire
LSM6DSLSensor *AccGyr_LSM6DS;
#endif

#if MAGNETO_LIS3MDL == 1
#include <LIS3MDLSensor.h>
#define DEV_I2C Wire
LIS3MDLSensor *Magneto;
#elif MAGNETO_ACC_LSM303 == 1
#include <LSM303AGR_ACC_Sensor.h>
#include <LSM303AGR_MAG_Sensor.h>
#define DEV_I2C Wire
LSM303AGR_ACC_Sensor *Acc_LSM303;
LSM303AGR_MAG_Sensor *Magneto;
#endif

#if THERMO_BMP180 == 1
// Connect VCC of the BMP085 sensor to 3.3V (NOT 5.0V!)
// Connect GND to Ground
// Connect SCL to i2c clock - on '168/'328 Arduino Uno/Duemilanove/etc thats Analog 5
// Connect SDA to i2c data - on '168/'328 Arduino Uno/Duemilanove/etc thats Analog 4
// EOC is not used, it signifies an end of conversion
// XCLR is a reset pin, also not used here
#include <Wire.h>
#include <Adafruit_BMP085.h>
Adafruit_BMP085 bmp;
#endif

void SetupSensors() {



#if THERMO_ADAFRUIT_DHT == 1 || SONOFF_TH10 == 1         //Adafruit DHT11/22/21 setup
  dht.begin();
#if THERMO_ADAFRUIT_DHT2 == 1
  dht2.begin();                                           //for the second DHT sensor
#endif
#endif



#if Dallas_DS18B20 > 0
  
  
#if Dallas_DS18B20_INT_PULLUP == 1
  pinMode(ONE_WIRE_BUS, INPUT_PULLUP);
#endif
  sensors.setWaitForConversion(false);
  sensors.begin();

  for(byte k=0;k<Dallas_DS18B20;k++) {
    sensors.getAddress(tempDeviceAddress[k], k);
    sensors.setResolution(tempDeviceAddress[k], 11);           //11 bits resolution
  }
  
  Serial.print(F("Dallas Temperature sensors: "));
  byte dallas_count = sensors.getDeviceCount();
  if (dallas_count > 0) {
    en_DallasTemperature = true;
    Serial.println(dallas_count);
    sensors.requestTemperatures();                       //first read
  } else {
    en_DallasTemperature = false;
    Serial.println(F("not found"));
  }

  /*Serial.print("Device 0 Address: ");
    for (uint8_t i = 0; i < 8; i++) {
    if (tempDeviceAddress[i] < 16)
      Serial.print("0");
    Serial.print(tempDeviceAddress[i], HEX);
    }
    Serial.println();
  */
#endif


#if THERMO_HTS221 == 1  || THERMO_HUM_LPS25HB == 1 || THERMO_HUM_LPS22HB == 1 || GYRO_ACC_LSM6DS0 == 1 || GYRO_ACC_LSM6DSL == 1 || MAGNETO_LIS3MDL == 1  || MAGNETO_ACC_LSM303 == 1
  // Initialize I2C bus.
  DEV_I2C.begin();
#endif

#if THERMO_HTS221 == 1
  // Initlialize components.
  HumTemp_HTS221 = new HTS221Sensor (&DEV_I2C);
  HumTemp_HTS221->Enable();
#endif


#if THERMO_HUM_LPS25HB == 1
  PressTemp_LPS = new LPS25HBSensor(&DEV_I2C);
  PressTemp_LPS->Enable();
#endif
#if THERMO_HUM_LPS22HB == 1
  PressTemp_LPS = new LPS22HBSensor(&DEV_I2C);
  PressTemp_LPS->Enable();
#endif


#if GYRO_ACC_LSM6DS0 == 1
  AccGyr_LSM6DS = new LSM6DS0Sensor(&DEV_I2C);
  AccGyr_LSM6DS->Enable_X();
  AccGyr_LSM6DS->Enable_G();
#elif GYRO_ACC_LSM6DSL == 1
  AccGyr_LSM6DS = new LSM6DSLSensor(&DEV_I2C);
  AccGyr_LSM6DS->Enable_X();
  AccGyr_LSM6DS->Enable_G();
#endif


#if MAGNETO_LIS3MDL == 1
  Magneto = new LIS3MDLSensor(&DEV_I2C);
  Magneto->Enable();
#elif MAGNETO_ACC_LSM303 == 1
  Acc_LSM303 = new LSM303AGR_ACC_Sensor(&DEV_I2C);
  Acc_LSM303->Enable();
  Magneto = new LSM303AGR_MAG_Sensor(&DEV_I2C);
  Magneto->Enable();
#endif


#if THERMO_BMP180 == 1
  if (!bmp.begin()) {
  Serial.println("Could not find a valid BMP085 sensor, check wiring!");
  }
#endif

}



/////////////////////////////////////////////////////////////////////
//Read sensors is periodically called to refresh the sensors
/////////////////////////////////////////////////////////////////////

void sensors_ReadAnalogSensors() {


#if THERMO_ADAFRUIT_MAX31855 == 1                             //THERMO_ADAFRUIT_MAX31855 read
  if (check_sensor_minutes[0]) {
    check_sensor_minutes[0] = false;
    double c = thermocouple.readCelsius();
    if (isnan(c))
      Arduino_User_var[4].value = 199;                        //means error
    else
      Arduino_User_var[4].value = c;                         //check if the access time of this sensor is high. Eventually you can read it every minute (see below)
  }
#endif



#if THERMO_ADAFRUIT_DHT == 1 || SONOFF_TH10 == 1  //Adafruit DHT11/22/21 read
  float h;
  float t;
  if (check_sensor_minutes[1]) {                            //read temperature and humidity every 1 minute
    check_sensor_minutes[1] = false;

    h = dht.readHumidity();
    t = dht.readTemperature();

#if DEBUG_SERIAL == 1
    if (isnan(h) || isnan(t)) {
      Serial.print(F("DHT - read error:"));
      Serial.println(t);
    } else {
      Serial.print(F("DHT - Temperature: "));
      Serial.println(t);
    }
#endif

    if (!isnan(h))
      Arduino_User_var[VIRTUAL_VAR_INDEX_HUM_DHT].value = h;                       //the Taccess is very high(500ms), so I read it avery minute
    else
      Arduino_User_var[VIRTUAL_VAR_INDEX_HUM_DHT].value = -99999;

    if (!isnan(t))
      Arduino_User_var[VIRTUAL_VAR_INDEX_TEMP_DHT].value = t;                      //the Taccess is very high(500ms), so I read it avery minute
    else
      Arduino_User_var[VIRTUAL_VAR_INDEX_TEMP_DHT].value = -99999;                  //ERROR KEYWORD


    //second DHT sensor
#if THERMO_ADAFRUIT_DHT2 == 1
    h = dht2.readHumidity();              //for a second DHT sensor
    t = dht2.readTemperature();           //for a second DHT sensor

#if DEBUG_SERIAL == 1
    if (isnan(h) || isnan(t)) {
      Serial.print(F("DHT2 - read error:"));
      Serial.println(t);
    } else {
      Serial.print(F("DHT2 - Temperature: "));
      Serial.println(t);
    }
#endif

    if (!isnan(h))
      Arduino_User_var[VIRTUAL_VAR_INDEX_HUM_DHT2].value = h;                       //the Taccess is very high(500ms), so I read it avery minute
    else
      Arduino_User_var[VIRTUAL_VAR_INDEX_HUM_DHT2].value = -99999;

    if (!isnan(t))
      Arduino_User_var[VIRTUAL_VAR_INDEX_TEMP_DHT2].value = t;                       //the Taccess is very high(500ms), so I read it avery minute
    else
      Arduino_User_var[VIRTUAL_VAR_INDEX_TEMP_DHT2].value = -99999;                 //ERROR

#endif
#if DEBUG_SERIAL == 1
    /*    Serial.print(F("hum:"));
      Serial.print(h);
      Serial.println(F("%"));
      Serial.print(F("temp:"));
      Serial.print(t);
      Serial.println(F("C"));*/
#endif
  }
#endif


#if Dallas_DS18B20 >0                                    //DallasTemperature Temperature Sensors DS18B20
  if (check_DallasTemperature && en_DallasTemperature) {
    check_DallasTemperature = false;

    //sensors.requestTemperatures();                               // Send the command to get temperatures
    //Here 5 sensors
    //Each sensor has an unique ID, this has to be extracted with a sample sketch
    //https://arduino-info.wikispaces.com/Brick-Temperature-DS18B20#Read%20individual
    //wait the conversion time
    //delay(375);

    //temp_temp = sensors.getTempCByIndex(0);                   //Read the sensors and fill the variables. These will be read by AndruinoApp
    byte t_i;
    for(t_i=0;t_i<Dallas_DS18B20;t_i++)
      Arduino_User_var[VIRTUAL_VAR_INDEX_TEMP_DS18B20+t_i].value = check_sensor_data_valid(sensors.getTempCByIndex(t_i), -127, "DS18B20");


    sensors.requestTemperatures();                              // Send the command to get temperature for the next read
  }
#endif


#if POWER_CONSUMPTION_ENABLE == 1
  if (check_power_consumption) {
    check_power_consumption = false;

    if (swap_timer == 0)
      Arduino_User_var[5].value = irms_CurrentIrms(IRMS0_ADC_CH, IRMS_CTRATIO, IRMS0_RSENSE, 500, ADC_STEP);  //read power from lights
    else
      Arduino_User_var[6].value = irms_CurrentIrms(IRMS1_ADC_CH, IRMS_CTRATIO, IRMS1_RSENSE, 500, ADC_STEP);  //read power from plugs
    swap_timer = !swap_timer;
  }
#endif


#if THERMO_SHT1x == 1
  if (check_sensor_minutes[2]) {                            //read temperature and humidity every 1 minute
    check_sensor_minutes[2] = false;

    float temp;
    float humidity;

    // Read values from the sensor
    temp = sht1x.readTemperatureC();
    //temp = sht1x.readTemperatureF();
    humidity = sht1x.readHumidity();

#if DEBUG_SERIAL == 1
    if (isnan(humidity) || isnan(temp)) {
      Serial.print(F("SHT1x - read error:"));
      Serial.println(temp);
    } else {
      Serial.print(F("SHT1x - Temperature: "));
      Serial.println(temp);
    }
#endif

    if (!isnan(humidity))
      Arduino_User_var[VIRTUAL_VAR_INDEX_HUM_SHT1x].value = humidity;                       //
    else
      Arduino_User_var[VIRTUAL_VAR_INDEX_HUM_SHT1x].value = -99999;

    if (!isnan(temp))
      Arduino_User_var[VIRTUAL_VAR_INDEX_TEMP_SHT1x].value = temp;                          //
    else
      Arduino_User_var[VIRTUAL_VAR_INDEX_TEMP_SHT1x].value = -99999;                        //ERROR KEYWORD

  }
#endif






#if THERMO_HTS221 == 1
  if (check_sensor_minutes[3]) {                             //read every 1 minute
    check_sensor_minutes[3] = false;
    byte var_sensor_index = 8;
    // Read humidity and temperature.
    float humidity, temperature;
    HumTemp_HTS221->GetHumidity(&humidity);
    HumTemp_HTS221->GetTemperature(&temperature);
    Arduino_User_var[var_sensor_index++].value = humidity;          //VAR8
    Arduino_User_var[var_sensor_index++].value = temperature;
#if DEBUG_SERIAL_SENSORS == 1
    Serial.print(F("Hum_HTS221: ")); Serial.print(humidity, 1); Serial.println("%");
    Serial.print(F("Temp_HTS221: ")); Serial.print(temperature, 1); Serial.println("C");
#endif
  }
#endif

#if THERMO_HUM_LPS25HB == 1 || THERMO_HUM_LPS22HB == 1
  if (check_sensor_minutes[4]) {                             //read every 1 minute
    check_sensor_minutes[4] = false;
    byte var_sensor_index = 10;
    // Read pressure.
    float pressure, temperature2;
    PressTemp_LPS->GetPressure(&pressure);
    PressTemp_LPS->GetTemperature(&temperature2);
    Arduino_User_var[var_sensor_index++].value = pressure;          //VAR10
    Arduino_User_var[var_sensor_index++].value = temperature2;
#if DEBUG_SERIAL_SENSORS == 1
    Serial.print(F("Pressione_LPS: ")); Serial.print(pressure, 1); Serial.println("hPa");
    Serial.print(F("Temp_LPS: ")); Serial.print(temperature2, 1); Serial.println("C");
#endif
  }
#endif

#if GYRO_ACC_LSM6DS0 == 1 || GYRO_ACC_LSM6DSL == 1
  if (check_sensor_seconds[0]) {                             //read every 1 minute
    check_sensor_seconds[1] = false;
    byte var_sensor_index = 12;
    // Read accelerometer and gyroscope.
    int32_t accelerometer[3];
    int32_t gyroscope[3];
    AccGyr_LSM6DS->Get_X_Axes(accelerometer);
    AccGyr_LSM6DS->Get_G_Axes(gyroscope);
    Arduino_User_var[var_sensor_index++].value = accelerometer[0];  //VAR12   //X
    Arduino_User_var[var_sensor_index++].value = accelerometer[1];            //Y
    Arduino_User_var[var_sensor_index++].value = accelerometer[2];            //Z

    Arduino_User_var[var_sensor_index++].value = gyroscope[0];  //VAR15   //X
    Arduino_User_var[var_sensor_index++].value = gyroscope[1];            //Y
    Arduino_User_var[var_sensor_index++].value = gyroscope[2];            //Z
#if DEBUG_SERIAL_SENSORS2 == 1
    Serial.print(F("accelerometer_LSM6DS - x:")); Serial.print(accelerometer[0]); Serial.print(", y:"); Serial.print(accelerometer[1]); Serial.print(", z:"); Serial.println(accelerometer[2]);
    Serial.print(F("gyroscope_LSM6DS - x:")); Serial.print(gyroscope[0]); Serial.print(", y:"); Serial.print(gyroscope[1]); Serial.print(", z:"); Serial.println(gyroscope[2]);
#endif
  }
#endif


#if MAGNETO_LIS3MDL == 1 || MAGNETO_ACC_LSM303 == 1
  if (check_sensor_seconds[1]) {                             //read every 1 minute
    check_sensor_seconds[1] = false;
    byte var_sensor_index = 18;
    // Read Magneto_array.
    int32_t Magneto_array[3];
    Magneto->GetAxes(Magneto_array);
    Arduino_User_var[var_sensor_index++].value = Magneto_array[0];  //VAR18
    Arduino_User_var[var_sensor_index++].value = Magneto_array[1];
    Arduino_User_var[var_sensor_index++].value = Magneto_array[2];  //VAR20

#if  MAGNETO_ACC_LSM303 == 1
    // Read accelerometer LSM303AGR.
    int32_t Acc_LSM303_array[3];
    Acc_LSM303->GetAxes(Acc_LSM303_array);
    Arduino_User_var[var_sensor_index++].value = Acc_LSM303_array[0];  //VAR21
    Arduino_User_var[var_sensor_index++].value = Acc_LSM303_array[1];
    Arduino_User_var[var_sensor_index++].value = Acc_LSM303_array[2];  //VAR23
#if DEBUG_SERIAL_SENSORS2 == 1
    Serial.print(F("Acc_LSM303 - x:")); Serial.print(Acc_LSM303_array[0]); Serial.print(", y:"); Serial.print(Acc_LSM303_array[1]); Serial.print(", z:"); Serial.println(Acc_LSM303_array[2]);
#endif
#endif

#if DEBUG_SERIAL_SENSORS2 == 1
    Serial.print(F("Magneto - x:")); Serial.print(Magneto_array[0]); Serial.print(", y:"); Serial.print(Magneto_array[1]); Serial.print(", z:"); Serial.println(Magneto_array[2]);
#endif
  }
#endif

#if THERMO_BMP180 == 1
  if (check_sensor_minutes[2]) {                            //read  every 1 minute
    check_sensor_minutes[2] = false;

    float temp,altitude_tmp,pressure,Sealpressure;

    temp = bmp.readTemperature();
    pressure = bmp.readPressure();
    altitude_tmp = bmp.readAltitude();
    Sealpressure = bmp.readSealevelPressure();

    Arduino_User_var[VIRTUAL_VAR_INDEX_TEMP_TMP180].value = temp;
    Arduino_User_var[VIRTUAL_VAR_INDEX_PRESS_TMP180].value = pressure/100;    //hPascal to have the data in 16bits
    Arduino_User_var[VIRTUAL_VAR_INDEX_ALT_TMP180].value = altitude_tmp;
    Arduino_User_var[VIRTUAL_VAR_INDEX_SEAL_PRESS_TMP180].value = Sealpressure;

    Serial.print("Temperature = ");
    Serial.print(temp);
    Serial.println(" *C");
    
    Serial.print("Pressure = ");
    Serial.print(Arduino_User_var[VIRTUAL_VAR_INDEX_PRESS_TMP180].value);
    Serial.println(" hPa");
    
    // Calculate altitude assuming 'standard' barometric
    // pressure of 1013.25 millibar = 101325 Pascal
    Serial.print("Altitude = ");
    Serial.print(bmp.readAltitude());
    Serial.println(" meters");

    Serial.print("Pressure at sealevel (calculated) = ");
    Serial.print(altitude_tmp);
    Serial.println(" Pa");
/*
  // you can get a more precise measurement of altitude
  // if you know the current sea level pressure which will
  // vary with weather and such. If it is 1015 millibars
  // that is equal to 101500 Pascals.
    Serial.print("Real altitude = ");
    Serial.print(bmp.readAltitude(101500));
    Serial.println(" meters");
*/
  }
#endif


}


//Arduino_User_var[VIRTUAL_VAR_INDEX_TEMP_DS18B20].value = check_sensor_data_valid(temp_temp, -127, "DS18B20");
float check_sensor_data_valid (float temp, float expected_data_error, char *array_name) {

   if(temp != expected_data_error) {
  #if DEBUG_SERIAL == 1
      Serial.print(array_name);
      Serial.print(F(" temperature: "));
      Serial.print(temp, 1);
      Serial.println(F("C"));
  #endif
      return(temp);
    } else {
  #if DEBUG_SERIAL == 1
      Serial.print(array_name);
      Serial.println(F(" read ERROR"));
  #endif
      return(-99999);
    }
}
