////////////////////////////////////////////////////////////////////////////////////////////////////
//ANDRUINO LIBRARY
//A.Scavuzzo
//www.andruino.it
////////////////////////////////////////////////////////////////////////////////////////////////////


bool  datalog_DataLogger(bool type, char *push_usr, char *arduino_name, char *arduino_pass);
bool  SendClient_Data_KeepALive(char *www_site, char *push_usr, char *arduino_name, char *arduino_pass, byte mode, keep_alive_type_e keep_alive);



bool  SendClient_3Packets_keepAlive (char *push_usr, char *arduino_name, char *arduino_pass)
{
  bool result = false;

  //  Serial.print(F("Time1:"));;Serial.print(((float)millis()/1000),2); Serial.println(F(" s"));
  result = SendClient_Data_KeepALive(andruino_it_ip_address, push_user, arduino_name, arduino_pass, 0, START_KEEP_ALIVE);    //-- analog + var + system
  //   Serial.print(F("Time2:"));Serial.print(((float)millis()/1000),2); Serial.println(F(" s"));
  if (result)
    SendClient_Data_KeepALive(andruino_it_ip_address, push_user, arduino_name, arduino_pass, 1, RUNNING_KEEP_ALIVE);    //-- IO + system
#if NRF24L_ENABLE == 1
  if (result)
    SendClient_Data_KeepALive(andruino_it_ip_address, push_user, arduino_name, arduino_pass, 2, RUNNING_KEEP_ALIVE);    //NRF
#endif
  //  Serial.print(F("Time3:"));Serial.print(((float)millis()/1000),2); Serial.println(F(" s"));

  if (!result) {
    ethbuff_ClientClear();
    ethbuff_delay_and_stop();
  } else
    _client.stop();


  //  send_sensor_logger_scan++;
  //  if(send_sensor_logger_scan>0){
  send_sensor_logger_scan = 0;
  send_http_notactive_client_req = false;
  send_ping_req = false;



  //FIX 10.0
  //   if(!active_iphone_connection)
  send_http_active_client_req = false;

  //  }

}


//SendDataLogger(push_user, board_name_array, ARDUINO_PASS, 0,0);

//0: analog+vars+system
//1: digital+System
//2: NRF module
//3: ZigBee module
//4: //system
bool  SendClient_Data_KeepALive(char *www_site, char *push_usr, char *arduino_name, char *arduino_pass, byte mode, keep_alive_type_e keep_alive)
{
  bool connected = false;
  byte retries = 0;
  char *result = 0;
  bool second_data;
  if (!push_CheckPin()) {
    return 0;
  }

#if DEBUG_SERIAL_CLIENT_SEND_DATA == 1
  Serial.print(F("Data client:"));
  Serial.print(F(" - mode:")); Serial.print(mode); Serial.print(F(" - ip:")); Serial.print(andruino_it_ip_address); Serial.print(F(": - "));
#endif

  //  char *result = 0;
  // close any connection before send a new request.
  // This will free the socket on the WiFi shield


  unsigned long int performance_start = millis();


  //is keep alive is already started then skip the connection again
  if (keep_alive == RUNNING_KEEP_ALIVE) {
    connected = true;
    //_client.flush();
  }

  //retries two times if connection is not estabilished
  while (!connected && retries < MAX_RETRIES_NUM) {
    if (retries > 0) {
      ethbuff_delay_and_stop();
#if DEBUG_SERIAL_CLIENT_SEND_DATA == 1
      Serial.print(F(" retries:")); Serial.print(retries);
#endif
    }
    //Serial.print(F("CONNECT TO ANDRUINO.it"));
    connected = _client.connect(www_site, 80);              //timeout 3sec
    //Serial.print(F("connected:"));Serial.println(connected);
    retries++;
  }

  if (connected) {    //andruino.it as number
#if DEBUG_SERIAL == 1
    //   Serial.println(F("result: PASS"));
#endif
    //client_fail_connected_cnt=0;
    ethbuff_ClientClear();                  //clear the TX buffer before use it


    ethbuff_ClientPrint(F("GET /iws4_arduino/data_client.php?user="));       //data client is used to send the sensors to server and then to iphone

    ethbuff_ClientPrint(push_usr);
    ethbuff_ClientPrint(F("&pin="));
    ethbuff_ClientPrint(pin_push_flash);
    ethbuff_ClientPrint(F("&ardu="));
    ethbuff_ClientPrint(arduino_name);
    ethbuff_ClientPrint(F("&mode="));
    ethbuff_ClientPrint(mode);
    ethbuff_ClientPrint(F("&json={"));


    switch (mode) {

      //analog+vars+system
      case 0:
        json_Arduino_io(2);             //2=arduino_io:analog, true=short json packet
        json_comma();
        json_Arduino_json_Vars();
        json_comma();
        json_Arduino_json_System();
        break;

      //digital+System
      case 1:
        json_Arduino_io(1);             //1=arduino_io:digital, true=short json packet
        //  json_comma();
        //  json_Arduino_json_System();
        break;

      //NRF module
      case 2:
#if NRF24L_ENABLE == 1
        json_NRF24L();
#endif
        break;

      //ZigBee module
      case 3:
        break;

      //system
      case 4:
        //json_Arduino_json_System();
        ethbuff_ClientPrint(F("ping"));
        break;
      default:
        break;
    }

    ethbuff_ClientPrint(F("}"));
    ethbuff_ClientFlush();          //check the data buffer, send the remain data and clean it

    result = ethclient_FinishGetStream(eth_buffer, sizeof(eth_buffer), "NO ERR", TIMEOUT_CLIENT_CONNECTION_LONG, keep_alive);

  }

  else {
#if DEBUG_SERIAL == 1
    Serial.println(F("result: FAIL"));
#endif
    ethbuff_delay_and_stop();
    client_fail_connected_cnt++;
  }



  if (!result) {
    client_cumulated_fails_cnt++;	           //increment the counter of bad connection (esp8266 timeout)
    client_consecutive_fails_cnt++;
  } else {
    client_consecutive_fails_cnt = 0;
    network_client_access++;
    Arduino_User_var[2].value = network_client_access;
  }

  http_client_performance_ms = (unsigned int)((unsigned long int)millis() - (unsigned long int)performance_start);
  if (http_client_performance_ms > http_client_performance_max_ms)
    http_client_performance_max_ms = http_client_performance_ms;

#if DEBUG_SERIAL_CLIENT == 1
  Serial.print(F("http_speed: ")); Serial.print(http_client_performance_ms); Serial.println(F("ms"));
  if (http_client_performance_ms > TIMEOUT_CLIENT_CONNECTION_LONG - 1 || !result) {
    Serial.print(F("Timeout report: push_fail_cnt:")); Serial.print(push_fail_cnt); Serial.print(F(", client_cumulated_fails_cnt:")); Serial.print(client_cumulated_fails_cnt); Serial.print(F(", client_consecutive_fails_cnt:")); Serial.print(client_consecutive_fails_cnt); Serial.print(F(", server_fail_cnt:")); Serial.println(server_fail_cnt);
  }
#endif


  if (result) {
    return true;
  }
  else {
    //client_cumulated_fails_cnt++;	           //increment the counter of bad connection
    return false;
  }

}









/*
  //arduino_io --INFO
  //              ANALOGS
  //
  //arduino_var--VARIABLES
  //
  //ardu_sys  -- ardu_date
  //              ardu_fd2
  //              ardu_fd

  //arduino_nrf24l:
  //                  NRF24L_io_0 -- INFO
  //                                  DIGITALS
  //                                  ANALOGS
  //
  //                  NRF24L_var_0-- VARIABLES


  {"arduino_io":{"INFO":["0"],"ANALOGS":[2.414,2.276,1.795,1.533,1.371,1.443,1.352,1.290,1.148,1.067,1.028,0.971,1.033,1.009,1.143,1.138]},"arduino_var":{"VARIABLES":[41.100,23.700,0.000,3362.000,0.000,0.563,1.247,0.000,0.000,0.000,0.000,0.000,0.000,0.000,0.000,0.000,0.000,0.000,0.000,0.000]},"ardu_tim":[255,255,255,255,255,255,255,255,255,255,255,255],"ardu_sys":{"ardu_date":[0,21,52,0],"ardu_fd2":["xxxxxxxx","0000","255.255.255.255","21414"],"ardu_fd":[0,0,0,1,0,0,7.090,7.090]}}

  {"arduino_io":{"INFO":["0"],"DIGITALS":[["3","pwm","0"],["4","out","1"],["5","out","0"],["6","out","0"],["7","out","0"],["8","out","0"],["9","in","0"],["10","out","1"],["11","out","0"],["12","out","0"],["13","out","0"],["14","out","0"],["15","out","0"],["16","out","0"],["17","out","0"],["18","out","0"],["19","out","0"],["20","out","0"],["21","out","0"],["22","in","0"],["23","in","0"],["24","in","0"],["25","in","0"],["26","out","0"],["27","out","0"],["28","out","0"],["29","out","0"]]}}


  {"arduino_nrf24l":{"NRF24L_io_0":{"INFO":["2","02","3290","88","340","0","1001","2","0"],"DIGITALS":[["3","in","1"],["4","in","1"],["5","out","0"],["9","out","0"]],"ANALOGS":[0.344,0.553,1.051,0.720]},"NRF24L_var_0":{"VARIABLES":[0.000,0.000,0.000,0.000,1.000]},"NRF24L_io_1":{"INFO":["1","012","2816","600","2396","0","1001","2","1"],"DIGITALS":[["3","in","1"],["4","in","1"],["5","out","0"],["9","out","0"]],"ANALOGS":[0.000,0.000,0.000,0.000]},"NRF24L_var_1":{"VARIABLES":[0.000,0.000,0.000,0.000,1.000]}}}


*/
