////////////////////////////////////////////////////////////////////////////////////////////////////
//ANDRUINO LIBRARY
//A.Scavuzzo
//www.andruino.it
//SET PINS
////////////////////////////////////////////////////////////////////////////////////////////////////



/*
 * According to the board option used in the file: A_SET_CONFIG (ARDUINO_2560MEGA or ESP8266_01_GENERIC, etc)
 * Modify your PINLIST in the right #if ARDUINO_2560MEGA == 1 below
 * 
 * Example: if you have selected the board: ARDUINO_2560MEGA follow the code:
 * #if ARDUINO_2560MEGA == 1
 * 
 * Example: if you have selected the board: NODE_MCU follow the code:
 * #if NODE_MCU == 1
 * 
 * 
 */


//blink a led every 4 second (LED_BUILTIN)
//#define BLINK_LED_RUNNING



//WARNING base_digital_pins_used, base_digital_pins_inv_used and base_digital_pins_mode_used has to be the same size (same element number)

//###############################################################
//ARDUINO MEGA
//###############################################################
//NRF uses: 48, 49, 50, 51, 52  (don't use them below)
//ESP8266 Wifi uses: 18, 19, 20 (don't use them below)
//Ethernet shield uses: 10 (CS), 50 (MISO), 51 (MOSI), 52 (SCK), 53 (SS)  (don't use them below)

#if ARDUINO_2560MEGA == 1
#define STARTUP_BLINK_LED_ENABLED
#define STARTUP_BLINK_LED LED_BUILTIN                                         
#define PARAM_MANAGER_TRIGGER_PIN -1                                                                                             //(-1 disabled) used to force the captive portal used to select the email, pin and board name
  const byte base_digital_pins_used[]     = {3,4,5,6,7,8,11,12,13,14,15,16,17,21,22,23,24,25,26,27,28,29,30,38};          //pin number used (pins can be not sequencial)
  const bool base_digital_pins_inv_used[] = {0,0,0,0,0,0,0 ,0 ,0 ,0 ,0 ,0 ,0 ,1 ,0 ,0 ,0 ,0, 0, 0, 0 ,0, 0, 0 };          //=1 if the pin has to be INVERTED POLARITY, 0 standard (DIG21 is inverted for example)
  const byte base_digital_pins_mode_used[]= {P,O,O,O,O,O,I ,I ,O ,O ,O ,O ,O ,O ,I ,I ,I ,I ,O, O ,O ,O ,O ,O };          //I=INPUT, O=OUTPUT, P=PWM (pins can be not sequencial)

  const byte base_analog_pins_used[]      = {0,1,2,3,4,5};                                                                        //ANA has to be sequencials (from zero)
  const byte base_variable_used[]         = {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16};                                           //VAR has to be sequencials (from zero)

//Dallas DS18B20
#define ONE_WIRE_BUS 5                                                                                                            // Data wire is plugged into pin 5 on the Arduino (you can change it)
//virtual pin (variable) where the temperature can be read by App
//If DS18B20 is enabled, this is the variable index number corresponding the the first DS18B20 connected (you can connect more than one)
#define VIRTUAL_VAR_INDEX_TEMP_DS18B20 7                                                                                          


//DHT22
#define DHT_PIN 2                                          // PIN 2 (you can change it), serial pin used to read the data from the sensor (one wire)
#define VIRTUAL_VAR_INDEX_HUM_DHT 0                        //virtual pin (variable) where the humidity can be read by App
#define VIRTUAL_VAR_INDEX_TEMP_DHT 1                       //virtual pin (variable) where the temperature can be read by App
//second DHT22 temperature sensor
#define DHT2_PIN 9                                         // PIN 9 (you can change it), serial pin used to read the data from the sensor (one wire)
#define VIRTUAL_VAR_INDEX_HUM_DHT2 5
#define VIRTUAL_VAR_INDEX_TEMP_DHT2 6

//THERMO_SHT1x
#define VIRTUAL_VAR_INDEX_HUM_SHT1x 5
#define VIRTUAL_VAR_INDEX_TEMP_SHT1x 6
#define THERMO_SHT1x_DATAPIN 10
#define THERMO_SHT1x_CLOCKPIN 11

//THERMO_BMP180/TMP080
#define VIRTUAL_VAR_INDEX_TEMP_TMP180 8
#define VIRTUAL_VAR_INDEX_PRESS_TMP180 9
#define VIRTUAL_VAR_INDEX_ALT_TMP180 10
#define VIRTUAL_VAR_INDEX_SEAL_PRESS_TMP180 11


//Arduino wifi shield esp8266 PINS (used PIN20)
#define WIFI_ESP8266_SHIELD_RESET_PIN 20
//#define WIFI_ESP8266_SHIELD_RX_PIN PA10
//#define WIFI_ESP8266_SHIELD_TX_PIN PA9


//NRF PINS
//PIN USED FOR NRF CE and CS (you can move as you want)
#define PIN_NRF_CE 49
#define PIN_NRF_CS 48


//###############################################################
//NodeMCU 1.0 (ESP12E module)
//GPIO 16: blue led
//###############################################################
#elif NODE_MCU == 1
#define PARAM_MANAGER_TRIGGER_PIN 0                                                                                              //(-1 disabled)used to force the captive portal used to select the Wifi, email, pin and board name
#define STARTUP_BLINK_LED_ENABLED                                                                                                //used to blink the led at startup
#define MCU_ESP8266_GPIO_LED 10

#define STARTUP_BLINK_LED MCU_ESP8266_GPIO_LED
  const byte base_digital_pins_used[]     = {2,3,4,5, 12,13,MCU_ESP8266_GPIO_LED};                                                  //pin number used (pins can be not sequencial)
  const bool base_digital_pins_inv_used[] = {0,0,0,0, 0, 0, 0};                                                                    //=1 if the pin has to be INVERTED POLARITY, 0 standard (DIG21 is inverted for example)
  const byte base_digital_pins_mode_used[]= {I,O,O,O, O, O, O};                                                                    //I=INPUT, O=OUTPUT, P=PWM (pins can be not sequencial)

  const byte base_analog_pins_used[]      = {0};                                                                                  //ANA has to be sequencials (from zero)
  const byte base_variable_used[]         = {0,1,2,3,4,5,6,7,8,9};                                                                //VAR has to be sequencials (from zero)

//Dallas DS18B20
#define ONE_WIRE_BUS 14                                     // Data wire is plugged into pin 4 on the Arduino (you can change it)
#define VIRTUAL_VAR_INDEX_TEMP_DS18B20 7                    //virtual pin (variable) where the temperature can be read by App

//DHT22
#define DHT_PIN 2                                          // PIN 2 (you can change it), serial pin used to read the data from the sensor (one wire)
#define VIRTUAL_VAR_INDEX_HUM_DHT 0                        //virtual pin (variable) where the humidity can be read by App
#define VIRTUAL_VAR_INDEX_TEMP_DHT 1                       //virtual pin (variable) where the temperature can be read by App
//second DHT22 temperature sensor
#define DHT2_PIN 9                                         // PIN 9 (you can change it), serial pin used to read the data from the sensor (one wire)
#define VIRTUAL_VAR_INDEX_HUM_DHT2 5
#define VIRTUAL_VAR_INDEX_TEMP_DHT2 6

//THERMO_SHT1x
#define VIRTUAL_VAR_INDEX_HUM_SHT1x 5
#define VIRTUAL_VAR_INDEX_TEMP_SHT1x 6
#define THERMO_SHT1x_DATAPIN 10
#define THERMO_SHT1x_CLOCKPIN 11

//THERMO_BMP180/TMP080
#define VIRTUAL_VAR_INDEX_TEMP_TMP180 8
#define VIRTUAL_VAR_INDEX_PRESS_TMP180 9
#define VIRTUAL_VAR_INDEX_ALT_TMP180 10
#define VIRTUAL_VAR_INDEX_SEAL_PRESS_TMP180 11

//###############################################################
//ESP12E module
//module standalone without reset and USB to serial
//Generic ESP8266, configure flash 512K: fs: 32, ota: 230
//###############################################################
#elif ESP8266_12E_CONF2 == 1
#define PARAM_MANAGER_TRIGGER_PIN -1                                                                                              //(-1 disabled)used to force the captive portal used to select the Wifi, email, pin and board name

  const byte base_digital_pins_used[]     = {2,3,4,5, 12,13};                                                  //pin number used (pins can be not sequencial)
  const bool base_digital_pins_inv_used[] = {1,0,0,0, 0, 0};                                                                    //=1 if the pin has to be INVERTED POLARITY, 0 standard (DIG21 is inverted for example)
  const byte base_digital_pins_mode_used[]= {O,O,O,O, O, O};                                                                    //I=INPUT, O=OUTPUT, P=PWM (pins can be not sequencial)

  const byte base_analog_pins_used[]      = {0};                                                                                  //ANA has to be sequencials (from zero)
  const byte base_variable_used[]         = {0,1,2,3,4,5,6,7,8,9};                                                                //VAR has to be sequencials (from zero)

//Dallas DS18B20
#define ONE_WIRE_BUS 14                                     // Data wire is plugged into pin 4 on the Arduino (you can change it)
#define VIRTUAL_VAR_INDEX_TEMP_DS18B20 7                    //virtual pin (variable) where the temperature can be read by App

//DHT22
#define DHT_PIN 2                                          // PIN 2 (you can change it), serial pin used to read the data from the sensor (one wire)
#define VIRTUAL_VAR_INDEX_HUM_DHT 0                        //virtual pin (variable) where the humidity can be read by App
#define VIRTUAL_VAR_INDEX_TEMP_DHT 1                       //virtual pin (variable) where the temperature can be read by App
//second DHT22 temperature sensor
#define DHT2_PIN 9                                         // PIN 9 (you can change it), serial pin used to read the data from the sensor (one wire)
#define VIRTUAL_VAR_INDEX_HUM_DHT2 5
#define VIRTUAL_VAR_INDEX_TEMP_DHT2 6

//THERMO_SHT1x
#define VIRTUAL_VAR_INDEX_HUM_SHT1x 5
#define VIRTUAL_VAR_INDEX_TEMP_SHT1x 6
#define THERMO_SHT1x_DATAPIN 10
#define THERMO_SHT1x_CLOCKPIN 11

//THERMO_BMP180/TMP080
#define VIRTUAL_VAR_INDEX_TEMP_TMP180 8
#define VIRTUAL_VAR_INDEX_PRESS_TMP180 9
#define VIRTUAL_VAR_INDEX_ALT_TMP180 10
#define VIRTUAL_VAR_INDEX_SEAL_PRESS_TMP180 11

//###############################################################
//Generic ESP8266-01
//GPIO 0/2
//###############################################################
#elif ESP8266_01_GENERIC == 1
#define PARAM_MANAGER_TRIGGER_PIN -1                                                                                              //(-1 disabled) used to force the captive portal used to select the Wifi, email, pin and board name
  const byte base_digital_pins_used[]     = {0,2};                                                                                //pin number used (pins can be not sequencial)
  const bool base_digital_pins_inv_used[] = {0,0};                                                                                //=1 if the pin has to be INVERTED POLARITY, 0 standard (DIG21 is inverted for example)
  const byte base_digital_pins_mode_used[]= {O,O};                                                                                //I=INPUT, O=OUTPUT, P=PWM (pins can be not sequencial)

  const byte base_analog_pins_used[]      = {0};                                                                                  //ANA has to be sequencials (from zero)
  const byte base_variable_used[]         = {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16};                                           //VAR has to be sequencials (from zero)

//Dallas DS18B20
#define ONE_WIRE_BUS 2                                     // Data wire is plugged into pin 4 on the Arduino (you can change it)
#define VIRTUAL_VAR_INDEX_TEMP_DS18B20 7                    //virtual pin (variable) where the temperature can be read by App

//DHT22
#define DHT_PIN 2                                          // PIN 2 (you can change it), serial pin used to read the data from the sensor (one wire)
#define VIRTUAL_VAR_INDEX_HUM_DHT 0                        //virtual pin (variable) where the humidity can be read by App
#define VIRTUAL_VAR_INDEX_TEMP_DHT 1                       //virtual pin (variable) where the temperature can be read by App


//###############################################################
//SonOff BASIC (based on esp8266)
//
//GPIO 12: out SonOff, GPIO 13: led SonOff, GPIO 0: input SonOff
//###############################################################
#elif SONOFF_BASIC == 1
#define PARAM_MANAGER_TRIGGER_PIN 0                                                                                           //(-1 disabled) used to force the captive portal used to select the Wifi, email, pin and board name
#define STARTUP_BLINK_LED_ENABLED                                                                                             //used to blink the led at startup
#define SONOFF_GPIO_RELAY 12
#define SONOFF_GPIO_LED 13
#define STARTUP_BLINK_LED SONOFF_GPIO_LED
  const byte base_digital_pins_used[]     = {0, SONOFF_GPIO_RELAY,SONOFF_GPIO_LED};                                           //pin number used (pins can be not sequencial)
  const bool base_digital_pins_inv_used[] = {0, 0, 1};                                                                        //=1 if the pin has to be INVERTED POLARITY, 0 standard (DIG21 is inverted for example)
  const byte base_digital_pins_mode_used[]= {I, O, O};                                                                        //I=INPUT, O=OUTPUT, P=PWM (pins can be not sequencial)

  const byte base_analog_pins_used[]      = {0};                                                                              //ANA has to be sequencials (from zero)
  const byte base_variable_used[]         = {0,1,2,3,4,5,6,7,8,9,10};                                                         //VAR has to be sequencials (from zero)



//###############################################################
//SonOff S20 (based on esp8266)
//Plug
//GPIO 12: out SonOff, GPIO 13: led SonOff, GPIO 0: input SonOff
//###############################################################
#elif SONOFF_S20 == 1
#define PARAM_MANAGER_TRIGGER_PIN 0                                                                                           //(-1 disabled) used to force the captive portal used to select the Wifi, email, pin and board name
#define STARTUP_BLINK_LED_ENABLED                                                                                             //used to blink the led at startup
#define SONOFF_GPIO_RELAY 12
#define SONOFF_GPIO_LED 13
#define STARTUP_BLINK_LED SONOFF_GPIO_LED
  const byte base_digital_pins_used[]     = {0, SONOFF_GPIO_RELAY,SONOFF_GPIO_LED};                                           //pin number used (pins can be not sequencial)
  const bool base_digital_pins_inv_used[] = {0, 0, 1};                                                                        //=1 if the pin has to be INVERTED POLARITY, 0 standard (DIG21 is inverted for example)
  const byte base_digital_pins_mode_used[]= {I, O, O};                                                                        //I=INPUT, O=OUTPUT, P=PWM (pins can be not sequencial)

  const byte base_analog_pins_used[]      = {0};                                                                              //ANA has to be sequencials (from zero)
  const byte base_variable_used[]         = {0,1,2,3,4,5,6,7,8,9,10};                                                         //VAR has to be sequencials (from zero)


//###############################################################
//SonOff TH10 (based on esp8266)
//temperature sensor
//GPIO 12: out SonOff, GPIO 13: led SonOff, GPIO 0: input SonOff, GPIO14 AM2301
//###############################################################
#elif SONOFF_TH10 == 1
#define PARAM_MANAGER_TRIGGER_PIN 0                                                                                           //(-1 disabled) used to force the captive portal used to select the Wifi, email, pin and board name
#define STARTUP_BLINK_LED_ENABLED                                                                                             //used to blink the led at startup
#define SONOFF_GPIO_RELAY 12
#define SONOFF_GPIO_LED 13
#define STARTUP_BLINK_LED SONOFF_GPIO_LED
  const byte base_digital_pins_used[]     = {0, SONOFF_GPIO_RELAY,SONOFF_GPIO_LED};                                           //pin number used (pins can be not sequencial)
  const bool base_digital_pins_inv_used[] = {0, 0, 1};                                                                        //=1 if the pin has to be INVERTED POLARITY, 0 standard (DIG21 is inverted for example)
  const byte base_digital_pins_mode_used[]= {I, O, O};                                                                        //I=INPUT, O=OUTPUT, P=PWM (pins can be not sequencial)

  const byte base_analog_pins_used[]      = {0};                                                                              //ANA has to be sequencials (from zero)
  const byte base_variable_used[]         = {0,1,2,3,4,5,6,7,8,9,10};                                                           //VAR has to be sequencials (from zero)


#define VIRTUAL_VAR_INDEX_HUM_DHT 0                        //virtual pin (variable) where the humidity can be read by App
#define VIRTUAL_VAR_INDEX_TEMP_DHT 1                       //virtual pin (variable) where the temperature can be read by App


//###############################################################
//STM32 NUCLEO 64
//###############################################################
#elif STM32_NUCLEO_64 == 1
#define STARTUP_BLINK_LED_ENABLED
#define STARTUP_BLINK_LED LED_BUILTIN                                                                                            //13
#define PARAM_MANAGER_TRIGGER_PIN PC13                                                                                           //(-1 disabled) used to force the captive portal used to select the email, pin and board name

//D0(PA3), D1(PA2): Serial print debug
//D2(PA10),D8(PA9),D3(PB3): serial1 for ESP8266
//D4,D5,D6: X-NUCLEO
//D14(PB9),D15(PB8): I2C1 for X-NUCLEO
  const byte base_digital_pins_used[]     = {3,  9,10,11,12,13,16,17,21,22,23,24,25,26,27,28,29,30,38};                           //pin number used (pins can be not sequencial)
  const bool base_digital_pins_inv_used[] = {0,  0, 0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0, 0, 0, 0 ,0, 0, 0 };                          //=1 if the pin has to be INVERTED POLARITY, 0 standard (DIG21 is inverted for example)
  const byte base_digital_pins_mode_used[]= {P,  O, O ,O ,O ,O ,O ,O ,O ,I ,I ,I ,I ,O, O ,O ,O ,O ,O };                          //I=INPUT, O=OUTPUT, P=PWM (pins can be not sequencial)


  const byte base_analog_pins_used[]      = {0,1,2,3,4,5};                                                                        //ANA has to be sequencials (from zero)
  const byte base_variable_used[]         = {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30}; //VAR has to be sequencials (from zero)

//Dallas DS18B20
#define ONE_WIRE_BUS PA0                                  // Data wire is plugged into pin 4 on the Arduino (you can change it)
#define VIRTUAL_VAR_INDEX_TEMP_DS18B20 7                 //virtual pin (variable) where the temperature can be read by App

//DHT22
#define DHT_PIN 2                                          // PIN 2 (you can change it), serial pin used to read the data from the sensor (one wire)
#define VIRTUAL_VAR_INDEX_HUM_DHT 0                        //virtual pin (variable) where the humidity can be read by App
#define VIRTUAL_VAR_INDEX_TEMP_DHT 1                       //virtual pin (variable) where the temperature can be read by App
//second DHT22 temperature sensor
#define DHT2_PIN 9                                         // PIN 9 (you can change it), serial pin used to read the data from the sensor (one wire)
#define VIRTUAL_VAR_INDEX_HUM_DHT2 5
#define VIRTUAL_VAR_INDEX_TEMP_DHT2 6

//THERMO_SHT1x
#define VIRTUAL_VAR_INDEX_HUM_SHT1x 5
#define VIRTUAL_VAR_INDEX_TEMP_SHT1x 6
#define THERMO_SHT1x_DATAPIN 10
#define THERMO_SHT1x_CLOCKPIN 11

//THERMO_BMP180/TMP080
#define VIRTUAL_VAR_INDEX_TEMP_TMP180 8
#define VIRTUAL_VAR_INDEX_PRESS_TMP180 9
#define VIRTUAL_VAR_INDEX_ALT_TMP180 10
#define VIRTUAL_VAR_INDEX_SEAL_PRESS_TMP180 11

//STM32 wifi shield esp8266 PINS
#define WIFI_ESP8266_SHIELD_RESET_PIN PA8  //PB3
#define WIFI_ESP8266_SHIELD_RX_PIN PA10
#define WIFI_ESP8266_SHIELD_TX_PIN PA9



//###############################################################
//STM32 NUCLEO 32
//###############################################################
#elif STM32_NUCLEO_32 == 1
#define STARTUP_BLINK_LED_ENABLED
#define STARTUP_BLINK_LED LED_BUILTIN                                                                                            //13
#define PARAM_MANAGER_TRIGGER_PIN -1                                                                                             //(-1 disabled) used to force the captive portal used to select the email, pin and board name
  const byte base_digital_pins_used[]     = {2,4,5,6,7,8,9,10, PB3};                                                                //pin number used (pins can be not sequencial)
  const bool base_digital_pins_inv_used[] = {0,0,0,0,0,0,0, 0, 0 };                                                               //=1 if the pin has to be INVERTED POLARITY, 0 standard (DIG21 is inverted for example)
  const byte base_digital_pins_mode_used[]= {I,O,O,O,O,O,I, O, O };                                                               //I=INPUT, O=OUTPUT, P=PWM (pins can be not sequencial)

  const byte base_analog_pins_used[]      = {0,1,2};                                                                               //ANA has to be sequencials (from zero)
  const byte base_variable_used[]         = {0,1,2,3,4,5,6,7,8,9,10};                                                           //VAR has to be sequencials (from zero)

//Dallas DS18B20
#define ONE_WIRE_BUS PA0                                  // Data wire is plugged into pin 4 on the Arduino (you can change it)
#define VIRTUAL_VAR_INDEX_TEMP_DS18B20 7                  //virtual pin (variable) where the temperature can be read by App

//DHT22
#define DHT_PIN 2                                          // PIN 2 (you can change it), serial pin used to read the data from the sensor (one wire)
#define VIRTUAL_VAR_INDEX_HUM_DHT 0                        //virtual pin (variable) where the humidity can be read by App
#define VIRTUAL_VAR_INDEX_TEMP_DHT 1                       //virtual pin (variable) where the temperature can be read by App
//second DHT22 temperature sensor
#define DHT2_PIN 9                                         // PIN 9 (you can change it), serial pin used to read the data from the sensor (one wire)
#define VIRTUAL_VAR_INDEX_HUM_DHT2 5
#define VIRTUAL_VAR_INDEX_TEMP_DHT2 6

//THERMO_SHT1x
#define VIRTUAL_VAR_INDEX_HUM_SHT1x 5
#define VIRTUAL_VAR_INDEX_TEMP_SHT1x 6
#define THERMO_SHT1x_DATAPIN 10
#define THERMO_SHT1x_CLOCKPIN 11

//THERMO_BMP180/TMP080
#define VIRTUAL_VAR_INDEX_TEMP_TMP180 8
#define VIRTUAL_VAR_INDEX_PRESS_TMP180 9
#define VIRTUAL_VAR_INDEX_ALT_TMP180 10
#define VIRTUAL_VAR_INDEX_SEAL_PRESS_TMP180 11

//STM32 wifi shield esp8266 PINS
#define WIFI_ESP8266_SHIELD_RESET_PIN PB0
#define WIFI_ESP8266_SHIELD_RX_PIN PA10
#define WIFI_ESP8266_SHIELD_TX_PIN PA9

#endif


//Pulse duration (ms)
#define PIN_PULSE_WIDTH 500                                                                                                       //IO pin pulse duration (500ms)
